/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.MessagingMessageSendRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class MessagingSendMessageRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private MessagingMessageSendRequestDto messagingMessageSendRequestDto;

    @JsonCreator
    public MessagingSendMessageRequest(
            String xAccountId,
            Optional<String> prefer,
            MessagingMessageSendRequestDto messagingMessageSendRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(messagingMessageSendRequestDto, "messagingMessageSendRequestDto");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.messagingMessageSendRequestDto = messagingMessageSendRequestDto;
    }
    
    public MessagingSendMessageRequest(
            String xAccountId,
            MessagingMessageSendRequestDto messagingMessageSendRequestDto) {
        this(xAccountId, Optional.empty(), messagingMessageSendRequestDto);
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @JsonIgnore
    public Optional<String> prefer() {
        return prefer;
    }

    @JsonIgnore
    public MessagingMessageSendRequestDto messagingMessageSendRequestDto() {
        return messagingMessageSendRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public MessagingSendMessageRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public MessagingSendMessageRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }


    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public MessagingSendMessageRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public MessagingSendMessageRequest withMessagingMessageSendRequestDto(MessagingMessageSendRequestDto messagingMessageSendRequestDto) {
        Utils.checkNotNull(messagingMessageSendRequestDto, "messagingMessageSendRequestDto");
        this.messagingMessageSendRequestDto = messagingMessageSendRequestDto;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MessagingSendMessageRequest other = (MessagingSendMessageRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.prefer, other.prefer) &&
            Utils.enhancedDeepEquals(this.messagingMessageSendRequestDto, other.messagingMessageSendRequestDto);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, prefer, messagingMessageSendRequestDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MessagingSendMessageRequest.class,
                "xAccountId", xAccountId,
                "prefer", prefer,
                "messagingMessageSendRequestDto", messagingMessageSendRequestDto);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private Optional<String> prefer = Optional.empty();

        private MessagingMessageSendRequestDto messagingMessageSendRequestDto;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }


        public Builder messagingMessageSendRequestDto(MessagingMessageSendRequestDto messagingMessageSendRequestDto) {
            Utils.checkNotNull(messagingMessageSendRequestDto, "messagingMessageSendRequestDto");
            this.messagingMessageSendRequestDto = messagingMessageSendRequestDto;
            return this;
        }

        public MessagingSendMessageRequest build() {

            return new MessagingSendMessageRequest(
                xAccountId, prefer, messagingMessageSendRequestDto);
        }

    }
}
