/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.utils.pagination;

import com.jayway.jsonpath.ReadContext;

// Internal API only

/**
 * Defines the strategy for tracking pagination state and progress.
 * This interface abstracts away the common concerns of:
 * 1. Parsing pagination metadata from responses
 * 2. Determining termination conditions
 * 3. Managing pagination state
 * <p>
 * The tracker is responsible for:
 * - Extracting pagination values from responses (e.g., next page number, cursor)
 * - Determining when pagination should stop
 * - Maintaining the current pagination state
 *
 * @param <ProgressParamT> The type of the progression parameter (e.g., page number, offset, cursor)
 */
public interface ProgressTrackerStrategy<ProgressParamT> {
    /**
     * Process the response and update pagination state.
     * This method should:
     * 1. Extract pagination metadata from the response
     * 2. Update internal state based on the metadata
     * 3. Return true if there are more pages to fetch, false otherwise
     *
     * @param respJson The JSON response to process
     * @return true if there are more pages to fetch, false otherwise
     */
    boolean advance(ReadContext respJson);

    /**
     * Get the current progression value to use in the next request.
     * This value will be used to modify the request for the next page.
     *
     * @return The current progression value
     */
    ProgressParamT getPosition();
}