/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CompletionValue {
    public static final CompletionValue PASS = new CompletionValue("Pass");
    public static final CompletionValue FAIL = new CompletionValue("Fail");
    public static final CompletionValue UNMAPPED_VALUE = new CompletionValue("unmapped_value");
    private static final Map<String, CompletionValue> values = CompletionValue.createValuesMap();
    private static final Map<String, CompletionValueEnum> enums = CompletionValue.createEnumsMap();
    private final String value;

    private CompletionValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static CompletionValue of(String value) {
        Class<CompletionValue> clazz = CompletionValue.class;
        synchronized (CompletionValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new CompletionValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<CompletionValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompletionValue other = (CompletionValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "CompletionValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompletionValue[] values() {
        Class<CompletionValue> clazz = CompletionValue.class;
        synchronized (CompletionValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new CompletionValue[0]);
        }
    }

    private static final Map<String, CompletionValue> createValuesMap() {
        LinkedHashMap<String, CompletionValue> map = new LinkedHashMap<String, CompletionValue>();
        map.put("Pass", PASS);
        map.put("Fail", FAIL);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, CompletionValueEnum> createEnumsMap() {
        HashMap<String, CompletionValueEnum> map = new HashMap<String, CompletionValueEnum>();
        map.put("Pass", CompletionValueEnum.PASS);
        map.put("Fail", CompletionValueEnum.FAIL);
        map.put("unmapped_value", CompletionValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum CompletionValueEnum {
        PASS("Pass"),
        FAIL("Fail"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private CompletionValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

