/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class EmploymentPayFrequencyValue {
    public static final EmploymentPayFrequencyValue HOURLY = new EmploymentPayFrequencyValue("hourly");
    public static final EmploymentPayFrequencyValue WEEKLY = new EmploymentPayFrequencyValue("weekly");
    public static final EmploymentPayFrequencyValue BI_WEEKLY = new EmploymentPayFrequencyValue("bi_weekly");
    public static final EmploymentPayFrequencyValue FOUR_WEEKLY = new EmploymentPayFrequencyValue("four_weekly");
    public static final EmploymentPayFrequencyValue SEMI_MONTHLY = new EmploymentPayFrequencyValue("semi_monthly");
    public static final EmploymentPayFrequencyValue MONTHLY = new EmploymentPayFrequencyValue("monthly");
    public static final EmploymentPayFrequencyValue BI_MONTHLY = new EmploymentPayFrequencyValue("bi_monthly");
    public static final EmploymentPayFrequencyValue QUARTERLY = new EmploymentPayFrequencyValue("quarterly");
    public static final EmploymentPayFrequencyValue SEMI_ANNUALLY = new EmploymentPayFrequencyValue("semi_annually");
    public static final EmploymentPayFrequencyValue YEARLY = new EmploymentPayFrequencyValue("yearly");
    public static final EmploymentPayFrequencyValue THIRTEEN_MONTHLY = new EmploymentPayFrequencyValue("thirteen_monthly");
    public static final EmploymentPayFrequencyValue PRO_RATA = new EmploymentPayFrequencyValue("pro_rata");
    public static final EmploymentPayFrequencyValue UNMAPPED_VALUE = new EmploymentPayFrequencyValue("unmapped_value");
    public static final EmploymentPayFrequencyValue HALF_YEARLY = new EmploymentPayFrequencyValue("half_yearly");
    public static final EmploymentPayFrequencyValue DAILY = new EmploymentPayFrequencyValue("daily");
    private static final Map<String, EmploymentPayFrequencyValue> values = EmploymentPayFrequencyValue.createValuesMap();
    private static final Map<String, EmploymentPayFrequencyValueEnum> enums = EmploymentPayFrequencyValue.createEnumsMap();
    private final String value;

    private EmploymentPayFrequencyValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static EmploymentPayFrequencyValue of(String value) {
        Class<EmploymentPayFrequencyValue> clazz = EmploymentPayFrequencyValue.class;
        synchronized (EmploymentPayFrequencyValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new EmploymentPayFrequencyValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<EmploymentPayFrequencyValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EmploymentPayFrequencyValue other = (EmploymentPayFrequencyValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "EmploymentPayFrequencyValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmploymentPayFrequencyValue[] values() {
        Class<EmploymentPayFrequencyValue> clazz = EmploymentPayFrequencyValue.class;
        synchronized (EmploymentPayFrequencyValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new EmploymentPayFrequencyValue[0]);
        }
    }

    private static final Map<String, EmploymentPayFrequencyValue> createValuesMap() {
        LinkedHashMap<String, EmploymentPayFrequencyValue> map = new LinkedHashMap<String, EmploymentPayFrequencyValue>();
        map.put("hourly", HOURLY);
        map.put("weekly", WEEKLY);
        map.put("bi_weekly", BI_WEEKLY);
        map.put("four_weekly", FOUR_WEEKLY);
        map.put("semi_monthly", SEMI_MONTHLY);
        map.put("monthly", MONTHLY);
        map.put("bi_monthly", BI_MONTHLY);
        map.put("quarterly", QUARTERLY);
        map.put("semi_annually", SEMI_ANNUALLY);
        map.put("yearly", YEARLY);
        map.put("thirteen_monthly", THIRTEEN_MONTHLY);
        map.put("pro_rata", PRO_RATA);
        map.put("unmapped_value", UNMAPPED_VALUE);
        map.put("half_yearly", HALF_YEARLY);
        map.put("daily", DAILY);
        return map;
    }

    private static final Map<String, EmploymentPayFrequencyValueEnum> createEnumsMap() {
        HashMap<String, EmploymentPayFrequencyValueEnum> map = new HashMap<String, EmploymentPayFrequencyValueEnum>();
        map.put("hourly", EmploymentPayFrequencyValueEnum.HOURLY);
        map.put("weekly", EmploymentPayFrequencyValueEnum.WEEKLY);
        map.put("bi_weekly", EmploymentPayFrequencyValueEnum.BI_WEEKLY);
        map.put("four_weekly", EmploymentPayFrequencyValueEnum.FOUR_WEEKLY);
        map.put("semi_monthly", EmploymentPayFrequencyValueEnum.SEMI_MONTHLY);
        map.put("monthly", EmploymentPayFrequencyValueEnum.MONTHLY);
        map.put("bi_monthly", EmploymentPayFrequencyValueEnum.BI_MONTHLY);
        map.put("quarterly", EmploymentPayFrequencyValueEnum.QUARTERLY);
        map.put("semi_annually", EmploymentPayFrequencyValueEnum.SEMI_ANNUALLY);
        map.put("yearly", EmploymentPayFrequencyValueEnum.YEARLY);
        map.put("thirteen_monthly", EmploymentPayFrequencyValueEnum.THIRTEEN_MONTHLY);
        map.put("pro_rata", EmploymentPayFrequencyValueEnum.PRO_RATA);
        map.put("unmapped_value", EmploymentPayFrequencyValueEnum.UNMAPPED_VALUE);
        map.put("half_yearly", EmploymentPayFrequencyValueEnum.HALF_YEARLY);
        map.put("daily", EmploymentPayFrequencyValueEnum.DAILY);
        return map;
    }

    public static enum EmploymentPayFrequencyValueEnum {
        HOURLY("hourly"),
        WEEKLY("weekly"),
        BI_WEEKLY("bi_weekly"),
        FOUR_WEEKLY("four_weekly"),
        SEMI_MONTHLY("semi_monthly"),
        MONTHLY("monthly"),
        BI_MONTHLY("bi_monthly"),
        QUARTERLY("quarterly"),
        SEMI_ANNUALLY("semi_annually"),
        YEARLY("yearly"),
        THIRTEEN_MONTHLY("thirteen_monthly"),
        PRO_RATA("pro_rata"),
        UNMAPPED_VALUE("unmapped_value"),
        HALF_YEARLY("half_yearly"),
        DAILY("daily");

        private final String value;

        private EmploymentPayFrequencyValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

