/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IamGroupValue {
    public static final IamGroupValue WORKSPACE = new IamGroupValue("workspace");
    public static final IamGroupValue TEAM = new IamGroupValue("team");
    public static final IamGroupValue DEPARTMENT = new IamGroupValue("department");
    public static final IamGroupValue GROUP = new IamGroupValue("group");
    public static final IamGroupValue ORGANIZATION = new IamGroupValue("organization");
    public static final IamGroupValue UNMAPPED_VALUE = new IamGroupValue("unmapped_value");
    public static final IamGroupValue COST_CENTER = new IamGroupValue("cost_center");
    private static final Map<String, IamGroupValue> values = IamGroupValue.createValuesMap();
    private static final Map<String, IamGroupValueEnum> enums = IamGroupValue.createEnumsMap();
    private final String value;

    private IamGroupValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static IamGroupValue of(String value) {
        Class<IamGroupValue> clazz = IamGroupValue.class;
        synchronized (IamGroupValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new IamGroupValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<IamGroupValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IamGroupValue other = (IamGroupValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "IamGroupValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IamGroupValue[] values() {
        Class<IamGroupValue> clazz = IamGroupValue.class;
        synchronized (IamGroupValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new IamGroupValue[0]);
        }
    }

    private static final Map<String, IamGroupValue> createValuesMap() {
        LinkedHashMap<String, IamGroupValue> map = new LinkedHashMap<String, IamGroupValue>();
        map.put("workspace", WORKSPACE);
        map.put("team", TEAM);
        map.put("department", DEPARTMENT);
        map.put("group", GROUP);
        map.put("organization", ORGANIZATION);
        map.put("unmapped_value", UNMAPPED_VALUE);
        map.put("cost_center", COST_CENTER);
        return map;
    }

    private static final Map<String, IamGroupValueEnum> createEnumsMap() {
        HashMap<String, IamGroupValueEnum> map = new HashMap<String, IamGroupValueEnum>();
        map.put("workspace", IamGroupValueEnum.WORKSPACE);
        map.put("team", IamGroupValueEnum.TEAM);
        map.put("department", IamGroupValueEnum.DEPARTMENT);
        map.put("group", IamGroupValueEnum.GROUP);
        map.put("organization", IamGroupValueEnum.ORGANIZATION);
        map.put("unmapped_value", IamGroupValueEnum.UNMAPPED_VALUE);
        map.put("cost_center", IamGroupValueEnum.COST_CENTER);
        return map;
    }

    public static enum IamGroupValueEnum {
        WORKSPACE("workspace"),
        TEAM("team"),
        DEPARTMENT("department"),
        GROUP("group"),
        ORGANIZATION("organization"),
        UNMAPPED_VALUE("unmapped_value"),
        COST_CENTER("cost_center");

        private final String value;

        private IamGroupValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

