/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.Headers;
import com.stackone.stackone_client_java.models.components.Raw;
import com.stackone.stackone_client_java.utils.Utils;
import org.openapitools.jackson.nullable.JsonNullable;

public class ProviderError {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="status")
    private JsonNullable<Double> status;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="url")
    private JsonNullable<String> url;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="raw")
    private JsonNullable<? extends Raw> raw;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="headers")
    private JsonNullable<? extends Headers> headers;

    @JsonCreator
    public ProviderError(@JsonProperty(value="status") JsonNullable<Double> status, @JsonProperty(value="url") JsonNullable<String> url, @JsonProperty(value="raw") JsonNullable<? extends Raw> raw, @JsonProperty(value="headers") JsonNullable<? extends Headers> headers) {
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(url, "url");
        Utils.checkNotNull(raw, "raw");
        Utils.checkNotNull(headers, "headers");
        this.status = status;
        this.url = url;
        this.raw = raw;
        this.headers = headers;
    }

    public ProviderError() {
        this((JsonNullable<Double>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<? extends Raw>)JsonNullable.undefined(), (JsonNullable<? extends Headers>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<Double> status() {
        return this.status;
    }

    @JsonIgnore
    public JsonNullable<String> url() {
        return this.url;
    }

    @JsonIgnore
    public JsonNullable<Raw> raw() {
        return this.raw;
    }

    @JsonIgnore
    public JsonNullable<Headers> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ProviderError withStatus(double status) {
        Utils.checkNotNull(status, "status");
        this.status = JsonNullable.of((Object)status);
        return this;
    }

    public ProviderError withStatus(JsonNullable<Double> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public ProviderError withUrl(String url) {
        Utils.checkNotNull(url, "url");
        this.url = JsonNullable.of((Object)url);
        return this;
    }

    public ProviderError withUrl(JsonNullable<String> url) {
        Utils.checkNotNull(url, "url");
        this.url = url;
        return this;
    }

    public ProviderError withRaw(Raw raw) {
        Utils.checkNotNull(raw, "raw");
        this.raw = JsonNullable.of((Object)raw);
        return this;
    }

    public ProviderError withRaw(JsonNullable<? extends Raw> raw) {
        Utils.checkNotNull(raw, "raw");
        this.raw = raw;
        return this;
    }

    public ProviderError withHeaders(Headers headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = JsonNullable.of((Object)headers);
        return this;
    }

    public ProviderError withHeaders(JsonNullable<? extends Headers> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProviderError other = (ProviderError)o;
        return Utils.enhancedDeepEquals(this.status, other.status) && Utils.enhancedDeepEquals(this.url, other.url) && Utils.enhancedDeepEquals(this.raw, other.raw) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.status, this.url, this.raw, this.headers);
    }

    public String toString() {
        return Utils.toString(ProviderError.class, "status", this.status, "url", this.url, "raw", this.raw, "headers", this.headers);
    }

    public static final class Builder {
        private JsonNullable<Double> status = JsonNullable.undefined();
        private JsonNullable<String> url = JsonNullable.undefined();
        private JsonNullable<? extends Raw> raw = JsonNullable.undefined();
        private JsonNullable<? extends Headers> headers = JsonNullable.undefined();

        private Builder() {
        }

        public Builder status(double status) {
            Utils.checkNotNull(status, "status");
            this.status = JsonNullable.of((Object)status);
            return this;
        }

        public Builder status(JsonNullable<Double> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder url(String url) {
            Utils.checkNotNull(url, "url");
            this.url = JsonNullable.of((Object)url);
            return this;
        }

        public Builder url(JsonNullable<String> url) {
            Utils.checkNotNull(url, "url");
            this.url = url;
            return this;
        }

        public Builder raw(Raw raw) {
            Utils.checkNotNull(raw, "raw");
            this.raw = JsonNullable.of((Object)raw);
            return this;
        }

        public Builder raw(JsonNullable<? extends Raw> raw) {
            Utils.checkNotNull(raw, "raw");
            this.raw = raw;
            return this;
        }

        public Builder headers(Headers headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = JsonNullable.of((Object)headers);
            return this;
        }

        public Builder headers(JsonNullable<? extends Headers> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public ProviderError build() {
            return new ProviderError(this.status, this.url, this.raw, this.headers);
        }
    }
}

