/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Type {
    public static final Type PRODUCTION = new Type("production");
    public static final Type TEST = new Type("test");
    private static final Map<String, Type> values = Type.createValuesMap();
    private static final Map<String, TypeEnum> enums = Type.createEnumsMap();
    private final String value;

    private Type(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static Type of(String value) {
        Class<Type> clazz = Type.class;
        synchronized (Type.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new Type((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<TypeEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Type other = (Type)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "Type [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Type[] values() {
        Class<Type> clazz = Type.class;
        synchronized (Type.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new Type[0]);
        }
    }

    private static final Map<String, Type> createValuesMap() {
        LinkedHashMap<String, Type> map = new LinkedHashMap<String, Type>();
        map.put("production", PRODUCTION);
        map.put("test", TEST);
        return map;
    }

    private static final Map<String, TypeEnum> createEnumsMap() {
        HashMap<String, TypeEnum> map = new HashMap<String, TypeEnum>();
        map.put("production", TypeEnum.PRODUCTION);
        map.put("test", TypeEnum.TEST);
        return map;
    }

    public static enum TypeEnum {
        PRODUCTION("production"),
        TEST("test");

        private final String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

