/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AtsCreateNotesRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class AtsCreateCandidateNoteRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private AtsCreateNotesRequestDto atsCreateNotesRequestDto;

    @JsonCreator
    public AtsCreateCandidateNoteRequest(String xAccountId, String id, Optional<String> prefer, AtsCreateNotesRequestDto atsCreateNotesRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(atsCreateNotesRequestDto, "atsCreateNotesRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.prefer = prefer;
        this.atsCreateNotesRequestDto = atsCreateNotesRequestDto;
    }

    public AtsCreateCandidateNoteRequest(String xAccountId, String id, AtsCreateNotesRequestDto atsCreateNotesRequestDto) {
        this(xAccountId, id, Optional.empty(), atsCreateNotesRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public AtsCreateNotesRequestDto atsCreateNotesRequestDto() {
        return this.atsCreateNotesRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsCreateCandidateNoteRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsCreateCandidateNoteRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public AtsCreateCandidateNoteRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public AtsCreateCandidateNoteRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public AtsCreateCandidateNoteRequest withAtsCreateNotesRequestDto(AtsCreateNotesRequestDto atsCreateNotesRequestDto) {
        Utils.checkNotNull(atsCreateNotesRequestDto, "atsCreateNotesRequestDto");
        this.atsCreateNotesRequestDto = atsCreateNotesRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsCreateCandidateNoteRequest other = (AtsCreateCandidateNoteRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.atsCreateNotesRequestDto, other.atsCreateNotesRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.id, this.prefer, this.atsCreateNotesRequestDto);
    }

    public String toString() {
        return Utils.toString(AtsCreateCandidateNoteRequest.class, "xAccountId", this.xAccountId, "id", this.id, "prefer", this.prefer, "atsCreateNotesRequestDto", this.atsCreateNotesRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private Optional<String> prefer = Optional.empty();
        private AtsCreateNotesRequestDto atsCreateNotesRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder atsCreateNotesRequestDto(AtsCreateNotesRequestDto atsCreateNotesRequestDto) {
            Utils.checkNotNull(atsCreateNotesRequestDto, "atsCreateNotesRequestDto");
            this.atsCreateNotesRequestDto = atsCreateNotesRequestDto;
            return this;
        }

        public AtsCreateCandidateNoteRequest build() {
            return new AtsCreateCandidateNoteRequest(this.xAccountId, this.id, this.prefer, this.atsCreateNotesRequestDto);
        }
    }
}

