/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.CrmCreateContactRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class CrmUpdateContactRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private CrmCreateContactRequestDto crmCreateContactRequestDto;

    @JsonCreator
    public CrmUpdateContactRequest(String xAccountId, String id, Optional<String> prefer, CrmCreateContactRequestDto crmCreateContactRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(crmCreateContactRequestDto, "crmCreateContactRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.prefer = prefer;
        this.crmCreateContactRequestDto = crmCreateContactRequestDto;
    }

    public CrmUpdateContactRequest(String xAccountId, String id, CrmCreateContactRequestDto crmCreateContactRequestDto) {
        this(xAccountId, id, Optional.empty(), crmCreateContactRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public CrmCreateContactRequestDto crmCreateContactRequestDto() {
        return this.crmCreateContactRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CrmUpdateContactRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public CrmUpdateContactRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public CrmUpdateContactRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public CrmUpdateContactRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public CrmUpdateContactRequest withCrmCreateContactRequestDto(CrmCreateContactRequestDto crmCreateContactRequestDto) {
        Utils.checkNotNull(crmCreateContactRequestDto, "crmCreateContactRequestDto");
        this.crmCreateContactRequestDto = crmCreateContactRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrmUpdateContactRequest other = (CrmUpdateContactRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.crmCreateContactRequestDto, other.crmCreateContactRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.id, this.prefer, this.crmCreateContactRequestDto);
    }

    public String toString() {
        return Utils.toString(CrmUpdateContactRequest.class, "xAccountId", this.xAccountId, "id", this.id, "prefer", this.prefer, "crmCreateContactRequestDto", this.crmCreateContactRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private Optional<String> prefer = Optional.empty();
        private CrmCreateContactRequestDto crmCreateContactRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder crmCreateContactRequestDto(CrmCreateContactRequestDto crmCreateContactRequestDto) {
            Utils.checkNotNull(crmCreateContactRequestDto, "crmCreateContactRequestDto");
            this.crmCreateContactRequestDto = crmCreateContactRequestDto;
            return this;
        }

        public CrmUpdateContactRequest build() {
            return new CrmUpdateContactRequest(this.xAccountId, this.id, this.prefer, this.crmCreateContactRequestDto);
        }
    }
}

