/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.MarketingCreateContentBlocksRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class MarketingUpdateContentBlockRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto;

    @JsonCreator
    public MarketingUpdateContentBlockRequest(String xAccountId, String id, Optional<String> prefer, MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(marketingCreateContentBlocksRequestDto, "marketingCreateContentBlocksRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.prefer = prefer;
        this.marketingCreateContentBlocksRequestDto = marketingCreateContentBlocksRequestDto;
    }

    public MarketingUpdateContentBlockRequest(String xAccountId, String id, MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto) {
        this(xAccountId, id, Optional.empty(), marketingCreateContentBlocksRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto() {
        return this.marketingCreateContentBlocksRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public MarketingUpdateContentBlockRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public MarketingUpdateContentBlockRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public MarketingUpdateContentBlockRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public MarketingUpdateContentBlockRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public MarketingUpdateContentBlockRequest withMarketingCreateContentBlocksRequestDto(MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto) {
        Utils.checkNotNull(marketingCreateContentBlocksRequestDto, "marketingCreateContentBlocksRequestDto");
        this.marketingCreateContentBlocksRequestDto = marketingCreateContentBlocksRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketingUpdateContentBlockRequest other = (MarketingUpdateContentBlockRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.marketingCreateContentBlocksRequestDto, other.marketingCreateContentBlocksRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.id, this.prefer, this.marketingCreateContentBlocksRequestDto);
    }

    public String toString() {
        return Utils.toString(MarketingUpdateContentBlockRequest.class, "xAccountId", this.xAccountId, "id", this.id, "prefer", this.prefer, "marketingCreateContentBlocksRequestDto", this.marketingCreateContentBlocksRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private Optional<String> prefer = Optional.empty();
        private MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder marketingCreateContentBlocksRequestDto(MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto) {
            Utils.checkNotNull(marketingCreateContentBlocksRequestDto, "marketingCreateContentBlocksRequestDto");
            this.marketingCreateContentBlocksRequestDto = marketingCreateContentBlocksRequestDto;
            return this;
        }

        public MarketingUpdateContentBlockRequest build() {
            return new MarketingUpdateContentBlockRequest(this.xAccountId, this.id, this.prefer, this.marketingCreateContentBlocksRequestDto);
        }
    }
}

