/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ScreeningCreateOrderRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class ScreeningCreateScreeningOrderRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private ScreeningCreateOrderRequestDto screeningCreateOrderRequestDto;

    @JsonCreator
    public ScreeningCreateScreeningOrderRequest(String xAccountId, Optional<String> prefer, ScreeningCreateOrderRequestDto screeningCreateOrderRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(screeningCreateOrderRequestDto, "screeningCreateOrderRequestDto");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.screeningCreateOrderRequestDto = screeningCreateOrderRequestDto;
    }

    public ScreeningCreateScreeningOrderRequest(String xAccountId, ScreeningCreateOrderRequestDto screeningCreateOrderRequestDto) {
        this(xAccountId, Optional.empty(), screeningCreateOrderRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public ScreeningCreateOrderRequestDto screeningCreateOrderRequestDto() {
        return this.screeningCreateOrderRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ScreeningCreateScreeningOrderRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public ScreeningCreateScreeningOrderRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public ScreeningCreateScreeningOrderRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public ScreeningCreateScreeningOrderRequest withScreeningCreateOrderRequestDto(ScreeningCreateOrderRequestDto screeningCreateOrderRequestDto) {
        Utils.checkNotNull(screeningCreateOrderRequestDto, "screeningCreateOrderRequestDto");
        this.screeningCreateOrderRequestDto = screeningCreateOrderRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScreeningCreateScreeningOrderRequest other = (ScreeningCreateScreeningOrderRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.screeningCreateOrderRequestDto, other.screeningCreateOrderRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.prefer, this.screeningCreateOrderRequestDto);
    }

    public String toString() {
        return Utils.toString(ScreeningCreateScreeningOrderRequest.class, "xAccountId", this.xAccountId, "prefer", this.prefer, "screeningCreateOrderRequestDto", this.screeningCreateOrderRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private Optional<String> prefer = Optional.empty();
        private ScreeningCreateOrderRequestDto screeningCreateOrderRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder screeningCreateOrderRequestDto(ScreeningCreateOrderRequestDto screeningCreateOrderRequestDto) {
            Utils.checkNotNull(screeningCreateOrderRequestDto, "screeningCreateOrderRequestDto");
            this.screeningCreateOrderRequestDto = screeningCreateOrderRequestDto;
            return this;
        }

        public ScreeningCreateScreeningOrderRequest build() {
            return new ScreeningCreateScreeningOrderRequest(this.xAccountId, this.prefer, this.screeningCreateOrderRequestDto);
        }
    }
}

