/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.AtsDocumentsUploadRequestDto;
import com.stackone.stackone_client_java.models.operations.AtsUploadApplicationDocumentRequest;
import com.stackone.stackone_client_java.models.operations.async.AtsUploadApplicationDocumentResponse;
import com.stackone.stackone_client_java.operations.AtsUploadApplicationDocument;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AtsUploadApplicationDocumentRequestBuilder {
    private String xAccountId;
    private String id;
    private Optional<String> prefer = Optional.empty();
    private AtsDocumentsUploadRequestDto atsDocumentsUploadRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public AtsUploadApplicationDocumentRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AtsUploadApplicationDocumentRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsUploadApplicationDocumentRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public AtsUploadApplicationDocumentRequestBuilder prefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.of(prefer);
        return this;
    }

    public AtsUploadApplicationDocumentRequestBuilder prefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public AtsUploadApplicationDocumentRequestBuilder atsDocumentsUploadRequestDto(AtsDocumentsUploadRequestDto atsDocumentsUploadRequestDto) {
        Utils.checkNotNull(atsDocumentsUploadRequestDto, "atsDocumentsUploadRequestDto");
        this.atsDocumentsUploadRequestDto = atsDocumentsUploadRequestDto;
        return this;
    }

    public AtsUploadApplicationDocumentRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AtsUploadApplicationDocumentRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private AtsUploadApplicationDocumentRequest buildRequest() {
        AtsUploadApplicationDocumentRequest request = new AtsUploadApplicationDocumentRequest(this.xAccountId, this.id, this.prefer, this.atsDocumentsUploadRequestDto);
        return request;
    }

    public CompletableFuture<AtsUploadApplicationDocumentResponse> call() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AtsUploadApplicationDocument.Async operation = new AtsUploadApplicationDocument.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), this._headers);
        AtsUploadApplicationDocumentRequest request = this.buildRequest();
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }
}

