/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.TicketingAttachmentsPaginated;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TicketingListAttachmentsResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends TicketingAttachmentsPaginated> ticketingAttachmentsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public TicketingListAttachmentsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends TicketingAttachmentsPaginated> ticketingAttachmentsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(ticketingAttachmentsPaginated, "ticketingAttachmentsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.ticketingAttachmentsPaginated = ticketingAttachmentsPaginated;
        this.headers = headers;
    }

    public TicketingListAttachmentsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<TicketingAttachmentsPaginated> ticketingAttachmentsPaginated() {
        return this.ticketingAttachmentsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public TicketingListAttachmentsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public TicketingListAttachmentsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public TicketingListAttachmentsResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public TicketingListAttachmentsResponse withTicketingAttachmentsPaginated(TicketingAttachmentsPaginated ticketingAttachmentsPaginated) {
        Utils.checkNotNull(ticketingAttachmentsPaginated, "ticketingAttachmentsPaginated");
        this.ticketingAttachmentsPaginated = Optional.ofNullable(ticketingAttachmentsPaginated);
        return this;
    }

    public TicketingListAttachmentsResponse withTicketingAttachmentsPaginated(Optional<? extends TicketingAttachmentsPaginated> ticketingAttachmentsPaginated) {
        Utils.checkNotNull(ticketingAttachmentsPaginated, "ticketingAttachmentsPaginated");
        this.ticketingAttachmentsPaginated = ticketingAttachmentsPaginated;
        return this;
    }

    public TicketingListAttachmentsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TicketingListAttachmentsResponse other = (TicketingListAttachmentsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.ticketingAttachmentsPaginated, other.ticketingAttachmentsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.ticketingAttachmentsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(TicketingListAttachmentsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "ticketingAttachmentsPaginated", this.ticketingAttachmentsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends TicketingAttachmentsPaginated> ticketingAttachmentsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder ticketingAttachmentsPaginated(TicketingAttachmentsPaginated ticketingAttachmentsPaginated) {
            Utils.checkNotNull(ticketingAttachmentsPaginated, "ticketingAttachmentsPaginated");
            this.ticketingAttachmentsPaginated = Optional.ofNullable(ticketingAttachmentsPaginated);
            return this;
        }

        public Builder ticketingAttachmentsPaginated(Optional<? extends TicketingAttachmentsPaginated> ticketingAttachmentsPaginated) {
            Utils.checkNotNull(ticketingAttachmentsPaginated, "ticketingAttachmentsPaginated");
            this.ticketingAttachmentsPaginated = ticketingAttachmentsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public TicketingListAttachmentsResponse build() {
            return new TicketingListAttachmentsResponse(this.contentType, this.statusCode, this.rawResponse, this.ticketingAttachmentsPaginated, this.headers);
        }
    }
}

