/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.utils;

import com.stackone.stackone_client_java.utils.BackoffStrategy;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.NonRetryableException;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.RetryableException;
import com.stackone.stackone_client_java.utils.SpeakeasyLogger;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class Retries {
    private static final SpeakeasyLogger logger = SpeakeasyLogger.getLogger(Retries.class);
    private final Callable<HttpResponse<InputStream>> action;
    private final RetryConfig retryConfig;
    private final List<String> statusCodes;

    private Retries(Callable<HttpResponse<InputStream>> action, RetryConfig retryConfig, List<String> statusCodes) {
        Utils.checkNotNull(action, "action");
        Utils.checkNotNull(retryConfig, "retryConfig");
        Utils.checkNotNull(statusCodes, "statusCodes");
        if (statusCodes.size() == 0) {
            throw new IllegalArgumentException("statusCodes list cannot be empty");
        }
        this.action = action;
        this.retryConfig = retryConfig;
        this.statusCodes = statusCodes;
    }

    public HttpResponse<InputStream> run() throws Exception {
        switch (this.retryConfig.strategy()) {
            case BACKOFF: {
                if (!this.retryConfig.backoff().isPresent()) {
                    throw new IllegalArgumentException("Backoff strategy is not defined");
                }
                BackoffStrategy backoff = this.retryConfig.backoff().get();
                return this.retryWithBackoff(backoff.retryConnectError(), backoff.retryReadTimeoutError());
            }
            case NONE: {
                return this.action.call();
            }
        }
        throw new IllegalArgumentException("Invalid retry strategy");
    }

    private HttpResponse<InputStream> getResponse(boolean retryConnectError, boolean retryReadTimeoutError) throws Exception {
        try {
            HttpResponse<InputStream> response = this.action.call();
            for (String statusCode : this.statusCodes) {
                int code;
                int statusMajor;
                int codeRange;
                if (!(statusCode.toUpperCase().contains("X") ? (codeRange = Integer.parseInt(statusCode.substring(0, 1))) == (statusMajor = response.statusCode() / 100) : (code = Integer.parseInt(statusCode)) == response.statusCode())) continue;
                throw new RetryableException(response);
            }
            return response;
        }
        catch (IOException e) {
            if (e instanceof ConnectException && retryConnectError) {
                throw e;
            }
            String message = e.getMessage();
            if (message != null) {
                if (message.contains("Connect timed out") && retryConnectError) {
                    throw e;
                }
                if (message.contains("Read timed out") && retryReadTimeoutError) {
                    throw e;
                }
            }
            throw new NonRetryableException(e);
        }
        catch (RetryableException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NonRetryableException(e);
        }
    }

    private HttpResponse<InputStream> retryWithBackoff(boolean retryConnectError, boolean retryReadTimeoutError) throws Exception {
        BackoffStrategy backoff = this.retryConfig.backoff().get();
        long initialIntervalMs = backoff.initialIntervalMs();
        long startMs = System.currentTimeMillis();
        int numAttempts = 0;
        while (true) {
            try {
                if (numAttempts > 0) {
                    logger.debug("Retry attempt {} after backoff", (Object)numAttempts);
                }
                return this.getResponse(retryConnectError, retryReadTimeoutError);
            }
            catch (NonRetryableException e) {
                logger.debug("Non-retryable exception encountered: {}", (Object)e.exception().getClass().getSimpleName());
                throw Exceptions.coerceException(e.exception());
            }
            catch (RetryableException | IOException e) {
                double maxIntervalMs;
                long nowMs = System.currentTimeMillis();
                if (nowMs - startMs > backoff.maxElapsedTimeMs()) {
                    logger.debug("Retry exhausted after {}ms, {} attempts", (Object)(nowMs - startMs), (Object)(numAttempts + 1));
                    if (e instanceof RetryableException) {
                        return ((RetryableException)e).response();
                    }
                    throw e;
                }
                double intervalMs = (double)initialIntervalMs * Math.pow(backoff.baseFactor(), numAttempts);
                double jitterMs = backoff.jitterFactor() * intervalMs;
                if ((intervalMs = intervalMs - jitterMs + Math.random() * (2.0 * jitterMs + 1.0)) > (maxIntervalMs = (double)backoff.maxIntervalMs())) {
                    intervalMs = maxIntervalMs;
                }
                long sleepMs = (long)intervalMs;
                if (logger.isTraceEnabled()) {
                    String reason = e instanceof RetryableException ? "status " + ((RetryableException)e).response().statusCode() : e.getClass().getSimpleName();
                    logger.trace("Retrying due to {} - waiting {}ms before attempt {}", reason, sleepMs, numAttempts + 1);
                }
                TimeUnit.MILLISECONDS.sleep(sleepMs);
                ++numAttempts;
                continue;
            }
            break;
        }
    }

    public static final Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Callable<HttpResponse<InputStream>> action;
        private RetryConfig retryConfig;
        private List<String> statusCodes;

        private Builder() {
        }

        public Builder action(Callable<HttpResponse<InputStream>> action) {
            Utils.checkNotNull(action, "action");
            this.action = action;
            return this;
        }

        public Builder retryConfig(RetryConfig retryConfig) {
            Utils.checkNotNull(retryConfig, "retryConfig");
            this.retryConfig = retryConfig;
            return this;
        }

        public Builder statusCodes(List<String> statusCodes) {
            Utils.checkNotNull(statusCodes, "statusCodes");
            if (statusCodes.size() == 0) {
                throw new IllegalArgumentException("statusCodes list cannot be empty");
            }
            this.statusCodes = statusCodes;
            return this;
        }

        public Retries build() {
            return new Retries(this.action, this.retryConfig, this.statusCodes);
        }
    }
}

