/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.Credentials;
import com.stackone.stackone_client_java.models.components.SetupInformation;
import com.stackone.stackone_client_java.models.components.Status;
import com.stackone.stackone_client_java.models.components.StatusReason;
import com.stackone.stackone_client_java.utils.Utils;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class LinkedAccount {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="provider")
    private String provider;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="provider_name")
    private JsonNullable<String> providerName;
    @JsonProperty(value="status")
    private Status status;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="status_reasons")
    private JsonNullable<? extends List<StatusReason>> statusReasons;
    @JsonProperty(value="origin_owner_id")
    private String originOwnerId;
    @JsonProperty(value="origin_owner_name")
    private String originOwnerName;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="origin_username")
    private JsonNullable<String> originUsername;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="credentials")
    private JsonNullable<? extends Credentials> credentials;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="setup_information")
    private JsonNullable<? extends SetupInformation> setupInformation;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="label")
    private JsonNullable<String> label;
    @JsonProperty(value="created_at")
    private OffsetDateTime createdAt;
    @JsonProperty(value="updated_at")
    private OffsetDateTime updatedAt;

    @JsonCreator
    public LinkedAccount(@JsonProperty(value="id") String id, @JsonProperty(value="provider") String provider, @JsonProperty(value="provider_name") JsonNullable<String> providerName, @JsonProperty(value="status") Status status, @JsonProperty(value="status_reasons") JsonNullable<? extends List<StatusReason>> statusReasons, @JsonProperty(value="origin_owner_id") String originOwnerId, @JsonProperty(value="origin_owner_name") String originOwnerName, @JsonProperty(value="origin_username") JsonNullable<String> originUsername, @JsonProperty(value="credentials") JsonNullable<? extends Credentials> credentials, @JsonProperty(value="setup_information") JsonNullable<? extends SetupInformation> setupInformation, @JsonProperty(value="label") JsonNullable<String> label, @JsonProperty(value="created_at") OffsetDateTime createdAt, @JsonProperty(value="updated_at") OffsetDateTime updatedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(provider, "provider");
        Utils.checkNotNull(providerName, "providerName");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(statusReasons, "statusReasons");
        Utils.checkNotNull(originOwnerId, "originOwnerId");
        Utils.checkNotNull(originOwnerName, "originOwnerName");
        Utils.checkNotNull(originUsername, "originUsername");
        Utils.checkNotNull(credentials, "credentials");
        Utils.checkNotNull(setupInformation, "setupInformation");
        Utils.checkNotNull(label, "label");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.id = id;
        this.provider = provider;
        this.providerName = providerName;
        this.status = status;
        this.statusReasons = statusReasons;
        this.originOwnerId = originOwnerId;
        this.originOwnerName = originOwnerName;
        this.originUsername = originUsername;
        this.credentials = credentials;
        this.setupInformation = setupInformation;
        this.label = label;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public LinkedAccount(String id, String provider, Status status, String originOwnerId, String originOwnerName, OffsetDateTime createdAt, OffsetDateTime updatedAt) {
        this(id, provider, (JsonNullable<String>)JsonNullable.undefined(), status, (JsonNullable<? extends List<StatusReason>>)JsonNullable.undefined(), originOwnerId, originOwnerName, (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<? extends Credentials>)JsonNullable.undefined(), (JsonNullable<? extends SetupInformation>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), createdAt, updatedAt);
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String provider() {
        return this.provider;
    }

    @JsonIgnore
    public JsonNullable<String> providerName() {
        return this.providerName;
    }

    @JsonIgnore
    public Status status() {
        return this.status;
    }

    @JsonIgnore
    public JsonNullable<List<StatusReason>> statusReasons() {
        return this.statusReasons;
    }

    @JsonIgnore
    public String originOwnerId() {
        return this.originOwnerId;
    }

    @JsonIgnore
    public String originOwnerName() {
        return this.originOwnerName;
    }

    @JsonIgnore
    public JsonNullable<String> originUsername() {
        return this.originUsername;
    }

    @JsonIgnore
    public JsonNullable<Credentials> credentials() {
        return this.credentials;
    }

    @JsonIgnore
    public JsonNullable<SetupInformation> setupInformation() {
        return this.setupInformation;
    }

    @JsonIgnore
    public JsonNullable<String> label() {
        return this.label;
    }

    @JsonIgnore
    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public OffsetDateTime updatedAt() {
        return this.updatedAt;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public LinkedAccount withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public LinkedAccount withProvider(String provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = provider;
        return this;
    }

    public LinkedAccount withProviderName(String providerName) {
        Utils.checkNotNull(providerName, "providerName");
        this.providerName = JsonNullable.of((Object)providerName);
        return this;
    }

    public LinkedAccount withProviderName(JsonNullable<String> providerName) {
        Utils.checkNotNull(providerName, "providerName");
        this.providerName = providerName;
        return this;
    }

    public LinkedAccount withStatus(Status status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public LinkedAccount withStatusReasons(List<StatusReason> statusReasons) {
        Utils.checkNotNull(statusReasons, "statusReasons");
        this.statusReasons = JsonNullable.of(statusReasons);
        return this;
    }

    public LinkedAccount withStatusReasons(JsonNullable<? extends List<StatusReason>> statusReasons) {
        Utils.checkNotNull(statusReasons, "statusReasons");
        this.statusReasons = statusReasons;
        return this;
    }

    public LinkedAccount withOriginOwnerId(String originOwnerId) {
        Utils.checkNotNull(originOwnerId, "originOwnerId");
        this.originOwnerId = originOwnerId;
        return this;
    }

    public LinkedAccount withOriginOwnerName(String originOwnerName) {
        Utils.checkNotNull(originOwnerName, "originOwnerName");
        this.originOwnerName = originOwnerName;
        return this;
    }

    public LinkedAccount withOriginUsername(String originUsername) {
        Utils.checkNotNull(originUsername, "originUsername");
        this.originUsername = JsonNullable.of((Object)originUsername);
        return this;
    }

    public LinkedAccount withOriginUsername(JsonNullable<String> originUsername) {
        Utils.checkNotNull(originUsername, "originUsername");
        this.originUsername = originUsername;
        return this;
    }

    public LinkedAccount withCredentials(Credentials credentials) {
        Utils.checkNotNull(credentials, "credentials");
        this.credentials = JsonNullable.of((Object)credentials);
        return this;
    }

    public LinkedAccount withCredentials(JsonNullable<? extends Credentials> credentials) {
        Utils.checkNotNull(credentials, "credentials");
        this.credentials = credentials;
        return this;
    }

    public LinkedAccount withSetupInformation(SetupInformation setupInformation) {
        Utils.checkNotNull(setupInformation, "setupInformation");
        this.setupInformation = JsonNullable.of((Object)setupInformation);
        return this;
    }

    public LinkedAccount withSetupInformation(JsonNullable<? extends SetupInformation> setupInformation) {
        Utils.checkNotNull(setupInformation, "setupInformation");
        this.setupInformation = setupInformation;
        return this;
    }

    public LinkedAccount withLabel(String label) {
        Utils.checkNotNull(label, "label");
        this.label = JsonNullable.of((Object)label);
        return this;
    }

    public LinkedAccount withLabel(JsonNullable<String> label) {
        Utils.checkNotNull(label, "label");
        this.label = label;
        return this;
    }

    public LinkedAccount withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public LinkedAccount withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkedAccount other = (LinkedAccount)o;
        return Objects.deepEquals(this.id, other.id) && Objects.deepEquals(this.provider, other.provider) && Objects.deepEquals(this.providerName, other.providerName) && Objects.deepEquals(this.status, other.status) && Objects.deepEquals(this.statusReasons, other.statusReasons) && Objects.deepEquals(this.originOwnerId, other.originOwnerId) && Objects.deepEquals(this.originOwnerName, other.originOwnerName) && Objects.deepEquals(this.originUsername, other.originUsername) && Objects.deepEquals(this.credentials, other.credentials) && Objects.deepEquals(this.setupInformation, other.setupInformation) && Objects.deepEquals(this.label, other.label) && Objects.deepEquals(this.createdAt, other.createdAt) && Objects.deepEquals(this.updatedAt, other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.provider, this.providerName, this.status, this.statusReasons, this.originOwnerId, this.originOwnerName, this.originUsername, this.credentials, this.setupInformation, this.label, this.createdAt, this.updatedAt);
    }

    public String toString() {
        return Utils.toString(LinkedAccount.class, "id", this.id, "provider", this.provider, "providerName", this.providerName, "status", this.status, "statusReasons", this.statusReasons, "originOwnerId", this.originOwnerId, "originOwnerName", this.originOwnerName, "originUsername", this.originUsername, "credentials", this.credentials, "setupInformation", this.setupInformation, "label", this.label, "createdAt", this.createdAt, "updatedAt", this.updatedAt);
    }

    public static final class Builder {
        private String id;
        private String provider;
        private JsonNullable<String> providerName = JsonNullable.undefined();
        private Status status;
        private JsonNullable<? extends List<StatusReason>> statusReasons = JsonNullable.undefined();
        private String originOwnerId;
        private String originOwnerName;
        private JsonNullable<String> originUsername = JsonNullable.undefined();
        private JsonNullable<? extends Credentials> credentials = JsonNullable.undefined();
        private JsonNullable<? extends SetupInformation> setupInformation = JsonNullable.undefined();
        private JsonNullable<String> label = JsonNullable.undefined();
        private OffsetDateTime createdAt;
        private OffsetDateTime updatedAt;

        private Builder() {
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder provider(String provider) {
            Utils.checkNotNull(provider, "provider");
            this.provider = provider;
            return this;
        }

        public Builder providerName(String providerName) {
            Utils.checkNotNull(providerName, "providerName");
            this.providerName = JsonNullable.of((Object)providerName);
            return this;
        }

        public Builder providerName(JsonNullable<String> providerName) {
            Utils.checkNotNull(providerName, "providerName");
            this.providerName = providerName;
            return this;
        }

        public Builder status(Status status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder statusReasons(List<StatusReason> statusReasons) {
            Utils.checkNotNull(statusReasons, "statusReasons");
            this.statusReasons = JsonNullable.of(statusReasons);
            return this;
        }

        public Builder statusReasons(JsonNullable<? extends List<StatusReason>> statusReasons) {
            Utils.checkNotNull(statusReasons, "statusReasons");
            this.statusReasons = statusReasons;
            return this;
        }

        public Builder originOwnerId(String originOwnerId) {
            Utils.checkNotNull(originOwnerId, "originOwnerId");
            this.originOwnerId = originOwnerId;
            return this;
        }

        public Builder originOwnerName(String originOwnerName) {
            Utils.checkNotNull(originOwnerName, "originOwnerName");
            this.originOwnerName = originOwnerName;
            return this;
        }

        public Builder originUsername(String originUsername) {
            Utils.checkNotNull(originUsername, "originUsername");
            this.originUsername = JsonNullable.of((Object)originUsername);
            return this;
        }

        public Builder originUsername(JsonNullable<String> originUsername) {
            Utils.checkNotNull(originUsername, "originUsername");
            this.originUsername = originUsername;
            return this;
        }

        public Builder credentials(Credentials credentials) {
            Utils.checkNotNull(credentials, "credentials");
            this.credentials = JsonNullable.of((Object)credentials);
            return this;
        }

        public Builder credentials(JsonNullable<? extends Credentials> credentials) {
            Utils.checkNotNull(credentials, "credentials");
            this.credentials = credentials;
            return this;
        }

        public Builder setupInformation(SetupInformation setupInformation) {
            Utils.checkNotNull(setupInformation, "setupInformation");
            this.setupInformation = JsonNullable.of((Object)setupInformation);
            return this;
        }

        public Builder setupInformation(JsonNullable<? extends SetupInformation> setupInformation) {
            Utils.checkNotNull(setupInformation, "setupInformation");
            this.setupInformation = setupInformation;
            return this;
        }

        public Builder label(String label) {
            Utils.checkNotNull(label, "label");
            this.label = JsonNullable.of((Object)label);
            return this;
        }

        public Builder label(JsonNullable<String> label) {
            Utils.checkNotNull(label, "label");
            this.label = label;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public LinkedAccount build() {
            return new LinkedAccount(this.id, this.provider, this.providerName, this.status, this.statusReasons, this.originOwnerId, this.originOwnerName, this.originUsername, this.credentials, this.setupInformation, this.label, this.createdAt, this.updatedAt);
        }
    }
}

