/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AccountsPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;

public class CrmListAccountsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends AccountsPaginated> accountsPaginated;
    private Map<String, List<String>> headers;
    private Callable<Optional<CrmListAccountsResponse>> next = () -> Optional.empty();

    @JsonCreator
    public CrmListAccountsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends AccountsPaginated> accountsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(accountsPaginated, "accountsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.accountsPaginated = accountsPaginated;
        this.headers = headers;
    }

    public CrmListAccountsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<AccountsPaginated> accountsPaginated() {
        return this.accountsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Optional<CrmListAccountsResponse> next() throws Exception {
        return this.next.call();
    }

    private CrmListAccountsResponse withNext(Callable<Optional<CrmListAccountsResponse>> next) {
        this.next = next;
        return this;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public CrmListAccountsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public CrmListAccountsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public CrmListAccountsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public CrmListAccountsResponse withAccountsPaginated(AccountsPaginated accountsPaginated) {
        Utils.checkNotNull(accountsPaginated, "accountsPaginated");
        this.accountsPaginated = Optional.ofNullable(accountsPaginated);
        return this;
    }

    public CrmListAccountsResponse withAccountsPaginated(Optional<? extends AccountsPaginated> accountsPaginated) {
        Utils.checkNotNull(accountsPaginated, "accountsPaginated");
        this.accountsPaginated = accountsPaginated;
        return this;
    }

    public CrmListAccountsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrmListAccountsResponse other = (CrmListAccountsResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.accountsPaginated, other.accountsPaginated) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.accountsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(CrmListAccountsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "accountsPaginated", this.accountsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private Callable<Optional<CrmListAccountsResponse>> next;
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends AccountsPaginated> accountsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder accountsPaginated(AccountsPaginated accountsPaginated) {
            Utils.checkNotNull(accountsPaginated, "accountsPaginated");
            this.accountsPaginated = Optional.ofNullable(accountsPaginated);
            return this;
        }

        public Builder accountsPaginated(Optional<? extends AccountsPaginated> accountsPaginated) {
            Utils.checkNotNull(accountsPaginated, "accountsPaginated");
            this.accountsPaginated = accountsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        @Deprecated
        public Builder next(Callable<Optional<CrmListAccountsResponse>> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }

        public CrmListAccountsResponse build() {
            return new CrmListAccountsResponse(this.contentType, this.statusCode, this.rawResponse, this.accountsPaginated, this.headers).withNext(this.next);
        }
    }
}

