/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class TimeOffBalancesValue {
    public static final TimeOffBalancesValue MINUTES = new TimeOffBalancesValue("minutes");
    public static final TimeOffBalancesValue HOURS = new TimeOffBalancesValue("hours");
    public static final TimeOffBalancesValue DAYS = new TimeOffBalancesValue("days");
    public static final TimeOffBalancesValue WEEKS = new TimeOffBalancesValue("weeks");
    public static final TimeOffBalancesValue MONTHS = new TimeOffBalancesValue("months");
    public static final TimeOffBalancesValue YEARS = new TimeOffBalancesValue("years");
    public static final TimeOffBalancesValue UNKNOWN = new TimeOffBalancesValue("unknown");
    public static final TimeOffBalancesValue UNMAPPED_VALUE = new TimeOffBalancesValue("unmapped_value");
    private static final Map<String, TimeOffBalancesValue> values = TimeOffBalancesValue.createValuesMap();
    private static final Map<String, TimeOffBalancesValueEnum> enums = TimeOffBalancesValue.createEnumsMap();
    private final String value;

    private TimeOffBalancesValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeOffBalancesValue of(String value) {
        Class<TimeOffBalancesValue> clazz = TimeOffBalancesValue.class;
        synchronized (TimeOffBalancesValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new TimeOffBalancesValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<TimeOffBalancesValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeOffBalancesValue other = (TimeOffBalancesValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "TimeOffBalancesValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeOffBalancesValue[] values() {
        Class<TimeOffBalancesValue> clazz = TimeOffBalancesValue.class;
        synchronized (TimeOffBalancesValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new TimeOffBalancesValue[0]);
        }
    }

    private static final Map<String, TimeOffBalancesValue> createValuesMap() {
        LinkedHashMap<String, TimeOffBalancesValue> map = new LinkedHashMap<String, TimeOffBalancesValue>();
        map.put("minutes", MINUTES);
        map.put("hours", HOURS);
        map.put("days", DAYS);
        map.put("weeks", WEEKS);
        map.put("months", MONTHS);
        map.put("years", YEARS);
        map.put("unknown", UNKNOWN);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TimeOffBalancesValueEnum> createEnumsMap() {
        HashMap<String, TimeOffBalancesValueEnum> map = new HashMap<String, TimeOffBalancesValueEnum>();
        map.put("minutes", TimeOffBalancesValueEnum.MINUTES);
        map.put("hours", TimeOffBalancesValueEnum.HOURS);
        map.put("days", TimeOffBalancesValueEnum.DAYS);
        map.put("weeks", TimeOffBalancesValueEnum.WEEKS);
        map.put("months", TimeOffBalancesValueEnum.MONTHS);
        map.put("years", TimeOffBalancesValueEnum.YEARS);
        map.put("unknown", TimeOffBalancesValueEnum.UNKNOWN);
        map.put("unmapped_value", TimeOffBalancesValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum TimeOffBalancesValueEnum {
        MINUTES("minutes"),
        HOURS("hours"),
        DAYS("days"),
        WEEKS("weeks"),
        MONTHS("months"),
        YEARS("years"),
        UNKNOWN("unknown"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private TimeOffBalancesValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<TimeOffBalancesValue> {
        protected _Deserializer() {
            super(TimeOffBalancesValue.class);
        }

        public TimeOffBalancesValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return TimeOffBalancesValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<TimeOffBalancesValue> {
        protected _Serializer() {
            super(TimeOffBalancesValue.class);
        }

        public void serialize(TimeOffBalancesValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

