/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * WorkLocation
 * 
 * <p>The employee work location
 */
public class WorkLocation {

    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("unified_custom_fields")
    private JsonNullable<? extends Map<String, Object>> unifiedCustomFields;

    /**
     * The employee ID
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("employee_id")
    private JsonNullable<String> employeeId;

    /**
     * Provider's unique identifier of the employee
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_employee_id")
    private JsonNullable<String> remoteEmployeeId;

    /**
     * The name of the location
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    /**
     * The phone number of the location
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("phone_number")
    private JsonNullable<String> phoneNumber;

    /**
     * The first line of the address
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("street_1")
    private JsonNullable<String> street1;

    /**
     * The second line of the address
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("street_2")
    private JsonNullable<String> street2;

    /**
     * The city where the location is situated
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("city")
    private JsonNullable<String> city;

    /**
     * The state where the location is situated
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("state")
    private JsonNullable<String> state;

    /**
     * The ZIP code/Postal code of the location
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("zip_code")
    private JsonNullable<String> zipCode;

    /**
     * The country code
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("country")
    private JsonNullable<? extends EmployeeCountry> country;

    /**
     * The location type
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("location_type")
    private JsonNullable<? extends EmployeeLocationType> locationType;

    /**
     * The created_at date
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * The updated_at date
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    @JsonCreator
    public WorkLocation(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("unified_custom_fields") JsonNullable<? extends Map<String, Object>> unifiedCustomFields,
            @JsonProperty("employee_id") JsonNullable<String> employeeId,
            @JsonProperty("remote_employee_id") JsonNullable<String> remoteEmployeeId,
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("phone_number") JsonNullable<String> phoneNumber,
            @JsonProperty("street_1") JsonNullable<String> street1,
            @JsonProperty("street_2") JsonNullable<String> street2,
            @JsonProperty("city") JsonNullable<String> city,
            @JsonProperty("state") JsonNullable<String> state,
            @JsonProperty("zip_code") JsonNullable<String> zipCode,
            @JsonProperty("country") JsonNullable<? extends EmployeeCountry> country,
            @JsonProperty("location_type") JsonNullable<? extends EmployeeLocationType> locationType,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        Utils.checkNotNull(employeeId, "employeeId");
        Utils.checkNotNull(remoteEmployeeId, "remoteEmployeeId");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(phoneNumber, "phoneNumber");
        Utils.checkNotNull(street1, "street1");
        Utils.checkNotNull(street2, "street2");
        Utils.checkNotNull(city, "city");
        Utils.checkNotNull(state, "state");
        Utils.checkNotNull(zipCode, "zipCode");
        Utils.checkNotNull(country, "country");
        Utils.checkNotNull(locationType, "locationType");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.id = id;
        this.remoteId = remoteId;
        this.unifiedCustomFields = unifiedCustomFields;
        this.employeeId = employeeId;
        this.remoteEmployeeId = remoteEmployeeId;
        this.name = name;
        this.phoneNumber = phoneNumber;
        this.street1 = street1;
        this.street2 = street2;
        this.city = city;
        this.state = state;
        this.zipCode = zipCode;
        this.country = country;
        this.locationType = locationType;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }
    
    public WorkLocation() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> unifiedCustomFields() {
        return (JsonNullable<Map<String, Object>>) unifiedCustomFields;
    }

    /**
     * The employee ID
     */
    @JsonIgnore
    public JsonNullable<String> employeeId() {
        return employeeId;
    }

    /**
     * Provider's unique identifier of the employee
     */
    @JsonIgnore
    public JsonNullable<String> remoteEmployeeId() {
        return remoteEmployeeId;
    }

    /**
     * The name of the location
     */
    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    /**
     * The phone number of the location
     */
    @JsonIgnore
    public JsonNullable<String> phoneNumber() {
        return phoneNumber;
    }

    /**
     * The first line of the address
     */
    @JsonIgnore
    public JsonNullable<String> street1() {
        return street1;
    }

    /**
     * The second line of the address
     */
    @JsonIgnore
    public JsonNullable<String> street2() {
        return street2;
    }

    /**
     * The city where the location is situated
     */
    @JsonIgnore
    public JsonNullable<String> city() {
        return city;
    }

    /**
     * The state where the location is situated
     */
    @JsonIgnore
    public JsonNullable<String> state() {
        return state;
    }

    /**
     * The ZIP code/Postal code of the location
     */
    @JsonIgnore
    public JsonNullable<String> zipCode() {
        return zipCode;
    }

    /**
     * The country code
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<EmployeeCountry> country() {
        return (JsonNullable<EmployeeCountry>) country;
    }

    /**
     * The location type
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<EmployeeLocationType> locationType() {
        return (JsonNullable<EmployeeLocationType>) locationType;
    }

    /**
     * The created_at date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * The updated_at date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Unique identifier
     */
    public WorkLocation withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public WorkLocation withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public WorkLocation withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public WorkLocation withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public WorkLocation withUnifiedCustomFields(Map<String, Object> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public WorkLocation withUnifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = unifiedCustomFields;
        return this;
    }

    /**
     * The employee ID
     */
    public WorkLocation withEmployeeId(String employeeId) {
        Utils.checkNotNull(employeeId, "employeeId");
        this.employeeId = JsonNullable.of(employeeId);
        return this;
    }

    /**
     * The employee ID
     */
    public WorkLocation withEmployeeId(JsonNullable<String> employeeId) {
        Utils.checkNotNull(employeeId, "employeeId");
        this.employeeId = employeeId;
        return this;
    }

    /**
     * Provider's unique identifier of the employee
     */
    public WorkLocation withRemoteEmployeeId(String remoteEmployeeId) {
        Utils.checkNotNull(remoteEmployeeId, "remoteEmployeeId");
        this.remoteEmployeeId = JsonNullable.of(remoteEmployeeId);
        return this;
    }

    /**
     * Provider's unique identifier of the employee
     */
    public WorkLocation withRemoteEmployeeId(JsonNullable<String> remoteEmployeeId) {
        Utils.checkNotNull(remoteEmployeeId, "remoteEmployeeId");
        this.remoteEmployeeId = remoteEmployeeId;
        return this;
    }

    /**
     * The name of the location
     */
    public WorkLocation withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    /**
     * The name of the location
     */
    public WorkLocation withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * The phone number of the location
     */
    public WorkLocation withPhoneNumber(String phoneNumber) {
        Utils.checkNotNull(phoneNumber, "phoneNumber");
        this.phoneNumber = JsonNullable.of(phoneNumber);
        return this;
    }

    /**
     * The phone number of the location
     */
    public WorkLocation withPhoneNumber(JsonNullable<String> phoneNumber) {
        Utils.checkNotNull(phoneNumber, "phoneNumber");
        this.phoneNumber = phoneNumber;
        return this;
    }

    /**
     * The first line of the address
     */
    public WorkLocation withStreet1(String street1) {
        Utils.checkNotNull(street1, "street1");
        this.street1 = JsonNullable.of(street1);
        return this;
    }

    /**
     * The first line of the address
     */
    public WorkLocation withStreet1(JsonNullable<String> street1) {
        Utils.checkNotNull(street1, "street1");
        this.street1 = street1;
        return this;
    }

    /**
     * The second line of the address
     */
    public WorkLocation withStreet2(String street2) {
        Utils.checkNotNull(street2, "street2");
        this.street2 = JsonNullable.of(street2);
        return this;
    }

    /**
     * The second line of the address
     */
    public WorkLocation withStreet2(JsonNullable<String> street2) {
        Utils.checkNotNull(street2, "street2");
        this.street2 = street2;
        return this;
    }

    /**
     * The city where the location is situated
     */
    public WorkLocation withCity(String city) {
        Utils.checkNotNull(city, "city");
        this.city = JsonNullable.of(city);
        return this;
    }

    /**
     * The city where the location is situated
     */
    public WorkLocation withCity(JsonNullable<String> city) {
        Utils.checkNotNull(city, "city");
        this.city = city;
        return this;
    }

    /**
     * The state where the location is situated
     */
    public WorkLocation withState(String state) {
        Utils.checkNotNull(state, "state");
        this.state = JsonNullable.of(state);
        return this;
    }

    /**
     * The state where the location is situated
     */
    public WorkLocation withState(JsonNullable<String> state) {
        Utils.checkNotNull(state, "state");
        this.state = state;
        return this;
    }

    /**
     * The ZIP code/Postal code of the location
     */
    public WorkLocation withZipCode(String zipCode) {
        Utils.checkNotNull(zipCode, "zipCode");
        this.zipCode = JsonNullable.of(zipCode);
        return this;
    }

    /**
     * The ZIP code/Postal code of the location
     */
    public WorkLocation withZipCode(JsonNullable<String> zipCode) {
        Utils.checkNotNull(zipCode, "zipCode");
        this.zipCode = zipCode;
        return this;
    }

    /**
     * The country code
     */
    public WorkLocation withCountry(EmployeeCountry country) {
        Utils.checkNotNull(country, "country");
        this.country = JsonNullable.of(country);
        return this;
    }

    /**
     * The country code
     */
    public WorkLocation withCountry(JsonNullable<? extends EmployeeCountry> country) {
        Utils.checkNotNull(country, "country");
        this.country = country;
        return this;
    }

    /**
     * The location type
     */
    public WorkLocation withLocationType(EmployeeLocationType locationType) {
        Utils.checkNotNull(locationType, "locationType");
        this.locationType = JsonNullable.of(locationType);
        return this;
    }

    /**
     * The location type
     */
    public WorkLocation withLocationType(JsonNullable<? extends EmployeeLocationType> locationType) {
        Utils.checkNotNull(locationType, "locationType");
        this.locationType = locationType;
        return this;
    }

    /**
     * The created_at date
     */
    public WorkLocation withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * The created_at date
     */
    public WorkLocation withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * The updated_at date
     */
    public WorkLocation withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * The updated_at date
     */
    public WorkLocation withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WorkLocation other = (WorkLocation) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.unifiedCustomFields, other.unifiedCustomFields) &&
            Utils.enhancedDeepEquals(this.employeeId, other.employeeId) &&
            Utils.enhancedDeepEquals(this.remoteEmployeeId, other.remoteEmployeeId) &&
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.phoneNumber, other.phoneNumber) &&
            Utils.enhancedDeepEquals(this.street1, other.street1) &&
            Utils.enhancedDeepEquals(this.street2, other.street2) &&
            Utils.enhancedDeepEquals(this.city, other.city) &&
            Utils.enhancedDeepEquals(this.state, other.state) &&
            Utils.enhancedDeepEquals(this.zipCode, other.zipCode) &&
            Utils.enhancedDeepEquals(this.country, other.country) &&
            Utils.enhancedDeepEquals(this.locationType, other.locationType) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt) &&
            Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id,
            remoteId,
            unifiedCustomFields,
            employeeId,
            remoteEmployeeId,
            name,
            phoneNumber,
            street1,
            street2,
            city,
            state,
            zipCode,
            country,
            locationType,
            createdAt,
            updatedAt);
    }
    
    @Override
    public String toString() {
        return Utils.toString(WorkLocation.class,
                "id", id,
                "remoteId", remoteId,
                "unifiedCustomFields", unifiedCustomFields,
                "employeeId", employeeId,
                "remoteEmployeeId", remoteEmployeeId,
                "name", name,
                "phoneNumber", phoneNumber,
                "street1", street1,
                "street2", street2,
                "city", city,
                "state", state,
                "zipCode", zipCode,
                "country", country,
                "locationType", locationType,
                "createdAt", createdAt,
                "updatedAt", updatedAt);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<String> remoteId = JsonNullable.undefined();
 
        private JsonNullable<? extends Map<String, Object>> unifiedCustomFields = JsonNullable.undefined();
 
        private JsonNullable<String> employeeId = JsonNullable.undefined();
 
        private JsonNullable<String> remoteEmployeeId = JsonNullable.undefined();
 
        private JsonNullable<String> name = JsonNullable.undefined();
 
        private JsonNullable<String> phoneNumber = JsonNullable.undefined();
 
        private JsonNullable<String> street1 = JsonNullable.undefined();
 
        private JsonNullable<String> street2 = JsonNullable.undefined();
 
        private JsonNullable<String> city = JsonNullable.undefined();
 
        private JsonNullable<String> state = JsonNullable.undefined();
 
        private JsonNullable<String> zipCode = JsonNullable.undefined();
 
        private JsonNullable<? extends EmployeeCountry> country = JsonNullable.undefined();
 
        private JsonNullable<? extends EmployeeLocationType> locationType = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(Map<String, Object> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = unifiedCustomFields;
            return this;
        }

        /**
         * The employee ID
         */
        public Builder employeeId(String employeeId) {
            Utils.checkNotNull(employeeId, "employeeId");
            this.employeeId = JsonNullable.of(employeeId);
            return this;
        }

        /**
         * The employee ID
         */
        public Builder employeeId(JsonNullable<String> employeeId) {
            Utils.checkNotNull(employeeId, "employeeId");
            this.employeeId = employeeId;
            return this;
        }

        /**
         * Provider's unique identifier of the employee
         */
        public Builder remoteEmployeeId(String remoteEmployeeId) {
            Utils.checkNotNull(remoteEmployeeId, "remoteEmployeeId");
            this.remoteEmployeeId = JsonNullable.of(remoteEmployeeId);
            return this;
        }

        /**
         * Provider's unique identifier of the employee
         */
        public Builder remoteEmployeeId(JsonNullable<String> remoteEmployeeId) {
            Utils.checkNotNull(remoteEmployeeId, "remoteEmployeeId");
            this.remoteEmployeeId = remoteEmployeeId;
            return this;
        }

        /**
         * The name of the location
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        /**
         * The name of the location
         */
        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        /**
         * The phone number of the location
         */
        public Builder phoneNumber(String phoneNumber) {
            Utils.checkNotNull(phoneNumber, "phoneNumber");
            this.phoneNumber = JsonNullable.of(phoneNumber);
            return this;
        }

        /**
         * The phone number of the location
         */
        public Builder phoneNumber(JsonNullable<String> phoneNumber) {
            Utils.checkNotNull(phoneNumber, "phoneNumber");
            this.phoneNumber = phoneNumber;
            return this;
        }

        /**
         * The first line of the address
         */
        public Builder street1(String street1) {
            Utils.checkNotNull(street1, "street1");
            this.street1 = JsonNullable.of(street1);
            return this;
        }

        /**
         * The first line of the address
         */
        public Builder street1(JsonNullable<String> street1) {
            Utils.checkNotNull(street1, "street1");
            this.street1 = street1;
            return this;
        }

        /**
         * The second line of the address
         */
        public Builder street2(String street2) {
            Utils.checkNotNull(street2, "street2");
            this.street2 = JsonNullable.of(street2);
            return this;
        }

        /**
         * The second line of the address
         */
        public Builder street2(JsonNullable<String> street2) {
            Utils.checkNotNull(street2, "street2");
            this.street2 = street2;
            return this;
        }

        /**
         * The city where the location is situated
         */
        public Builder city(String city) {
            Utils.checkNotNull(city, "city");
            this.city = JsonNullable.of(city);
            return this;
        }

        /**
         * The city where the location is situated
         */
        public Builder city(JsonNullable<String> city) {
            Utils.checkNotNull(city, "city");
            this.city = city;
            return this;
        }

        /**
         * The state where the location is situated
         */
        public Builder state(String state) {
            Utils.checkNotNull(state, "state");
            this.state = JsonNullable.of(state);
            return this;
        }

        /**
         * The state where the location is situated
         */
        public Builder state(JsonNullable<String> state) {
            Utils.checkNotNull(state, "state");
            this.state = state;
            return this;
        }

        /**
         * The ZIP code/Postal code of the location
         */
        public Builder zipCode(String zipCode) {
            Utils.checkNotNull(zipCode, "zipCode");
            this.zipCode = JsonNullable.of(zipCode);
            return this;
        }

        /**
         * The ZIP code/Postal code of the location
         */
        public Builder zipCode(JsonNullable<String> zipCode) {
            Utils.checkNotNull(zipCode, "zipCode");
            this.zipCode = zipCode;
            return this;
        }

        /**
         * The country code
         */
        public Builder country(EmployeeCountry country) {
            Utils.checkNotNull(country, "country");
            this.country = JsonNullable.of(country);
            return this;
        }

        /**
         * The country code
         */
        public Builder country(JsonNullable<? extends EmployeeCountry> country) {
            Utils.checkNotNull(country, "country");
            this.country = country;
            return this;
        }

        /**
         * The location type
         */
        public Builder locationType(EmployeeLocationType locationType) {
            Utils.checkNotNull(locationType, "locationType");
            this.locationType = JsonNullable.of(locationType);
            return this;
        }

        /**
         * The location type
         */
        public Builder locationType(JsonNullable<? extends EmployeeLocationType> locationType) {
            Utils.checkNotNull(locationType, "locationType");
            this.locationType = locationType;
            return this;
        }

        /**
         * The created_at date
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * The created_at date
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        /**
         * The updated_at date
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * The updated_at date
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }
        
        public WorkLocation build() {
            return new WorkLocation(
                id,
                remoteId,
                unifiedCustomFields,
                employeeId,
                remoteEmployeeId,
                name,
                phoneNumber,
                street1,
                street2,
                city,
                state,
                zipCode,
                country,
                locationType,
                createdAt,
                updatedAt);
        }
    }
}
