/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;

public class WriteResultApiModel {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("statusCode")
    private JsonNullable<Double> statusCode;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("message")
    private JsonNullable<String> message;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("timestamp")
    private JsonNullable<OffsetDateTime> timestamp;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("provider_errors")
    private JsonNullable<? extends List<ProviderErrorApiModel>> providerErrors;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("unified_warnings")
    private JsonNullable<? extends List<UnifiedWarningApiModel>> unifiedWarnings;

    @JsonCreator
    public WriteResultApiModel(
            @JsonProperty("statusCode") JsonNullable<Double> statusCode,
            @JsonProperty("message") JsonNullable<String> message,
            @JsonProperty("timestamp") JsonNullable<OffsetDateTime> timestamp,
            @JsonProperty("provider_errors") JsonNullable<? extends List<ProviderErrorApiModel>> providerErrors,
            @JsonProperty("unified_warnings") JsonNullable<? extends List<UnifiedWarningApiModel>> unifiedWarnings) {
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(message, "message");
        Utils.checkNotNull(timestamp, "timestamp");
        Utils.checkNotNull(providerErrors, "providerErrors");
        Utils.checkNotNull(unifiedWarnings, "unifiedWarnings");
        this.statusCode = statusCode;
        this.message = message;
        this.timestamp = timestamp;
        this.providerErrors = providerErrors;
        this.unifiedWarnings = unifiedWarnings;
    }
    
    public WriteResultApiModel() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<Double> statusCode() {
        return statusCode;
    }

    @JsonIgnore
    public JsonNullable<String> message() {
        return message;
    }

    @JsonIgnore
    public JsonNullable<OffsetDateTime> timestamp() {
        return timestamp;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<ProviderErrorApiModel>> providerErrors() {
        return (JsonNullable<List<ProviderErrorApiModel>>) providerErrors;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<UnifiedWarningApiModel>> unifiedWarnings() {
        return (JsonNullable<List<UnifiedWarningApiModel>>) unifiedWarnings;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public WriteResultApiModel withStatusCode(double statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = JsonNullable.of(statusCode);
        return this;
    }

    public WriteResultApiModel withStatusCode(JsonNullable<Double> statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public WriteResultApiModel withMessage(String message) {
        Utils.checkNotNull(message, "message");
        this.message = JsonNullable.of(message);
        return this;
    }

    public WriteResultApiModel withMessage(JsonNullable<String> message) {
        Utils.checkNotNull(message, "message");
        this.message = message;
        return this;
    }

    public WriteResultApiModel withTimestamp(OffsetDateTime timestamp) {
        Utils.checkNotNull(timestamp, "timestamp");
        this.timestamp = JsonNullable.of(timestamp);
        return this;
    }

    public WriteResultApiModel withTimestamp(JsonNullable<OffsetDateTime> timestamp) {
        Utils.checkNotNull(timestamp, "timestamp");
        this.timestamp = timestamp;
        return this;
    }

    public WriteResultApiModel withProviderErrors(List<ProviderErrorApiModel> providerErrors) {
        Utils.checkNotNull(providerErrors, "providerErrors");
        this.providerErrors = JsonNullable.of(providerErrors);
        return this;
    }

    public WriteResultApiModel withProviderErrors(JsonNullable<? extends List<ProviderErrorApiModel>> providerErrors) {
        Utils.checkNotNull(providerErrors, "providerErrors");
        this.providerErrors = providerErrors;
        return this;
    }

    public WriteResultApiModel withUnifiedWarnings(List<UnifiedWarningApiModel> unifiedWarnings) {
        Utils.checkNotNull(unifiedWarnings, "unifiedWarnings");
        this.unifiedWarnings = JsonNullable.of(unifiedWarnings);
        return this;
    }

    public WriteResultApiModel withUnifiedWarnings(JsonNullable<? extends List<UnifiedWarningApiModel>> unifiedWarnings) {
        Utils.checkNotNull(unifiedWarnings, "unifiedWarnings");
        this.unifiedWarnings = unifiedWarnings;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WriteResultApiModel other = (WriteResultApiModel) o;
        return 
            Utils.enhancedDeepEquals(this.statusCode, other.statusCode) &&
            Utils.enhancedDeepEquals(this.message, other.message) &&
            Utils.enhancedDeepEquals(this.timestamp, other.timestamp) &&
            Utils.enhancedDeepEquals(this.providerErrors, other.providerErrors) &&
            Utils.enhancedDeepEquals(this.unifiedWarnings, other.unifiedWarnings);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            statusCode,
            message,
            timestamp,
            providerErrors,
            unifiedWarnings);
    }
    
    @Override
    public String toString() {
        return Utils.toString(WriteResultApiModel.class,
                "statusCode", statusCode,
                "message", message,
                "timestamp", timestamp,
                "providerErrors", providerErrors,
                "unifiedWarnings", unifiedWarnings);
    }
    
    public final static class Builder {
 
        private JsonNullable<Double> statusCode = JsonNullable.undefined();
 
        private JsonNullable<String> message = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> timestamp = JsonNullable.undefined();
 
        private JsonNullable<? extends List<ProviderErrorApiModel>> providerErrors = JsonNullable.undefined();
 
        private JsonNullable<? extends List<UnifiedWarningApiModel>> unifiedWarnings = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder statusCode(double statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = JsonNullable.of(statusCode);
            return this;
        }

        public Builder statusCode(JsonNullable<Double> statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder message(String message) {
            Utils.checkNotNull(message, "message");
            this.message = JsonNullable.of(message);
            return this;
        }

        public Builder message(JsonNullable<String> message) {
            Utils.checkNotNull(message, "message");
            this.message = message;
            return this;
        }

        public Builder timestamp(OffsetDateTime timestamp) {
            Utils.checkNotNull(timestamp, "timestamp");
            this.timestamp = JsonNullable.of(timestamp);
            return this;
        }

        public Builder timestamp(JsonNullable<OffsetDateTime> timestamp) {
            Utils.checkNotNull(timestamp, "timestamp");
            this.timestamp = timestamp;
            return this;
        }

        public Builder providerErrors(List<ProviderErrorApiModel> providerErrors) {
            Utils.checkNotNull(providerErrors, "providerErrors");
            this.providerErrors = JsonNullable.of(providerErrors);
            return this;
        }

        public Builder providerErrors(JsonNullable<? extends List<ProviderErrorApiModel>> providerErrors) {
            Utils.checkNotNull(providerErrors, "providerErrors");
            this.providerErrors = providerErrors;
            return this;
        }

        public Builder unifiedWarnings(List<UnifiedWarningApiModel> unifiedWarnings) {
            Utils.checkNotNull(unifiedWarnings, "unifiedWarnings");
            this.unifiedWarnings = JsonNullable.of(unifiedWarnings);
            return this;
        }

        public Builder unifiedWarnings(JsonNullable<? extends List<UnifiedWarningApiModel>> unifiedWarnings) {
            Utils.checkNotNull(unifiedWarnings, "unifiedWarnings");
            this.unifiedWarnings = unifiedWarnings;
            return this;
        }
        
        public WriteResultApiModel build() {
            return new WriteResultApiModel(
                statusCode,
                message,
                timestamp,
                providerErrors,
                unifiedWarnings);
        }
    }
}
