/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.operations;

import static com.stackone.stackone_client_java.operations.Operations.RequestOperation;

import com.fasterxml.jackson.core.type.TypeReference;
import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.SecuritySource;
import com.stackone.stackone_client_java.models.components.LinkedAccountMeta;
import com.stackone.stackone_client_java.models.errors.BadGatewayResponse;
import com.stackone.stackone_client_java.models.errors.BadRequestResponse;
import com.stackone.stackone_client_java.models.errors.ConflictResponse;
import com.stackone.stackone_client_java.models.errors.ForbiddenResponse;
import com.stackone.stackone_client_java.models.errors.InternalServerErrorResponse;
import com.stackone.stackone_client_java.models.errors.NotFoundResponse;
import com.stackone.stackone_client_java.models.errors.NotImplementedResponse;
import com.stackone.stackone_client_java.models.errors.RequestTimedOutResponse;
import com.stackone.stackone_client_java.models.errors.SDKError;
import com.stackone.stackone_client_java.models.errors.TooManyRequestsResponse;
import com.stackone.stackone_client_java.models.errors.UnauthorizedResponse;
import com.stackone.stackone_client_java.models.errors.UnprocessableEntityResponse;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountMetaInfoRequest;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountMetaInfoResponse;
import com.stackone.stackone_client_java.utils.BackoffStrategy;
import com.stackone.stackone_client_java.utils.HTTPClient;
import com.stackone.stackone_client_java.utils.HTTPRequest;
import com.stackone.stackone_client_java.utils.Hook.AfterErrorContextImpl;
import com.stackone.stackone_client_java.utils.Hook.AfterSuccessContextImpl;
import com.stackone.stackone_client_java.utils.Hook.BeforeRequestContextImpl;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.Retries.NonRetryableException;
import com.stackone.stackone_client_java.utils.Retries;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.lang.Exception;
import java.lang.String;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;


public class StackoneGetAccountMetaInfoOperation implements RequestOperation<StackoneGetAccountMetaInfoRequest, StackoneGetAccountMetaInfoResponse> {
    
    private final SDKConfiguration sdkConfiguration;
    private final Optional<Options> options;

    public StackoneGetAccountMetaInfoOperation(
            SDKConfiguration sdkConfiguration,
            Optional<Options> options) {
        this.sdkConfiguration = sdkConfiguration;
        this.options = options;
    }
    
    @Override
    public HttpResponse<InputStream> doRequest(StackoneGetAccountMetaInfoRequest request) throws Exception {
        options.ifPresent(o -> o.validate(List.of(Options.Option.RETRY_CONFIG)));
        String baseUrl = this.sdkConfiguration.serverUrl();
        String url = Utils.generateURL(
                StackoneGetAccountMetaInfoRequest.class,
                baseUrl,
                "/accounts/{id}/meta",
                request, null);
        
        HTTPRequest req = new HTTPRequest(url, "GET");
        req.addHeader("Accept", "application/json")
            .addHeader("user-agent", 
                SDKConfiguration.USER_AGENT);
        
        Optional<SecuritySource> hookSecuritySource = Optional.of(this.sdkConfiguration.securitySource());
        Utils.configureSecurity(req,  
                this.sdkConfiguration.securitySource().getSecurity());
        HTTPClient client = this.sdkConfiguration.client();
        HTTPRequest finalReq = req;
        RetryConfig retryConfig = options
                .flatMap(Options::retryConfig)
                .or(this.sdkConfiguration::retryConfig)
                .orElse(RetryConfig.builder()
                        .backoff(BackoffStrategy.builder()
                            .initialInterval(500, TimeUnit.MILLISECONDS)
                            .maxInterval(60000, TimeUnit.MILLISECONDS)
                            .baseFactor((double)(1.5))
                            .maxElapsedTime(3600000, TimeUnit.MILLISECONDS)
                            .retryConnectError(true)
                            .build())
                        .build());
        List<String> statusCodes = new ArrayList<>();
        statusCodes.add("429");
        statusCodes.add("408");
        Retries retries = Retries.builder()
            .action(() -> {
                HttpRequest r = null;
                try {
                    r = sdkConfiguration.hooks()
                        .beforeRequest(
                            new BeforeRequestContextImpl(
                                this.sdkConfiguration,
                                baseUrl,
                                "stackone_get_account_meta_info", 
                                java.util.Optional.of(java.util.List.of()), 
                                hookSecuritySource),
                            finalReq.build());
                } catch (Exception e) {
                    throw new NonRetryableException(e);
                }
                try {
                    return client.send(r);
                } catch (Exception e) {
                    return sdkConfiguration.hooks()
                        .afterError(
                            new AfterErrorContextImpl(
                                this.sdkConfiguration,
                                baseUrl,
                                "stackone_get_account_meta_info",
                                 java.util.Optional.of(java.util.List.of()),
                                 hookSecuritySource), 
                            Optional.empty(),
                            Optional.of(e));
                }
            })
            .retryConfig(retryConfig)
            .statusCodes(statusCodes)
            .build();
        HttpResponse<InputStream> httpRes = sdkConfiguration.hooks()
                 .afterSuccess(
                     new AfterSuccessContextImpl(
                         this.sdkConfiguration,
                          baseUrl,
                         "stackone_get_account_meta_info", 
                         java.util.Optional.of(java.util.List.of()), 
                         hookSecuritySource),
                     retries.run());
    
        return httpRes;
    }

    @Override
    public StackoneGetAccountMetaInfoResponse handleResponse(HttpResponse<InputStream> response) throws Exception {
        String contentType = response
            .headers()
            .firstValue("Content-Type")
            .orElse("application/octet-stream");
        StackoneGetAccountMetaInfoResponse.Builder resBuilder = 
            StackoneGetAccountMetaInfoResponse
                .builder()
                .contentType(contentType)
                .statusCode(response.statusCode())
                .rawResponse(response);

        StackoneGetAccountMetaInfoResponse res = resBuilder.build();
        
        if (Utils.statusCodeMatches(response.statusCode(), "200")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                LinkedAccountMeta out = Utils.mapper().readValue(
                    response.body(),
                    new TypeReference<>() {
                    });
                res.withLinkedAccountMeta(out);
                return res;
            } else {
                throw new SDKError(
                    response, 
                    response.statusCode(), 
                    "Unexpected content-type received: " + contentType, 
                    Utils.extractByteArrayFromBody(response));
            }
        }
        if (Utils.statusCodeMatches(response.statusCode(), "400")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                BadRequestResponse out = Utils.mapper().readValue(
                    response.body(),
                    new TypeReference<>() {
                    });
                throw out;
            } else {
                throw new SDKError(
                    response, 
                    response.statusCode(), 
                    "Unexpected content-type received: " + contentType, 
                    Utils.extractByteArrayFromBody(response));
            }
        }
        if (Utils.statusCodeMatches(response.statusCode(), "401")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                UnauthorizedResponse out = Utils.mapper().readValue(
                    response.body(),
                    new TypeReference<>() {
                    });
                throw out;
            } else {
                throw new SDKError(
                    response, 
                    response.statusCode(), 
                    "Unexpected content-type received: " + contentType, 
                    Utils.extractByteArrayFromBody(response));
            }
        }
        if (Utils.statusCodeMatches(response.statusCode(), "403")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                ForbiddenResponse out = Utils.mapper().readValue(
                    response.body(),
                    new TypeReference<>() {
                    });
                throw out;
            } else {
                throw new SDKError(
                    response, 
                    response.statusCode(), 
                    "Unexpected content-type received: " + contentType, 
                    Utils.extractByteArrayFromBody(response));
            }
        }
        if (Utils.statusCodeMatches(response.statusCode(), "404")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                NotFoundResponse out = Utils.mapper().readValue(
                    response.body(),
                    new TypeReference<>() {
                    });
                throw out;
            } else {
                throw new SDKError(
                    response, 
                    response.statusCode(), 
                    "Unexpected content-type received: " + contentType, 
                    Utils.extractByteArrayFromBody(response));
            }
        }
        if (Utils.statusCodeMatches(response.statusCode(), "408")) {
            res.withHeaders(response.headers().map());
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                RequestTimedOutResponse out = Utils.mapper().readValue(
                    response.body(),
                    new TypeReference<>() {
                    });
                throw out;
            } else {
                throw new SDKError(
                    response, 
                    response.statusCode(), 
                    "Unexpected content-type received: " + contentType, 
                    Utils.extractByteArrayFromBody(response));
            }
        }
        if (Utils.statusCodeMatches(response.statusCode(), "409")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                ConflictResponse out = Utils.mapper().readValue(
                    response.body(),
                    new TypeReference<>() {
                    });
                throw out;
            } else {
                throw new SDKError(
                    response, 
                    response.statusCode(), 
                    "Unexpected content-type received: " + contentType, 
                    Utils.extractByteArrayFromBody(response));
            }
        }
        if (Utils.statusCodeMatches(response.statusCode(), "422")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                UnprocessableEntityResponse out = Utils.mapper().readValue(
                    response.body(),
                    new TypeReference<>() {
                    });
                throw out;
            } else {
                throw new SDKError(
                    response, 
                    response.statusCode(), 
                    "Unexpected content-type received: " + contentType, 
                    Utils.extractByteArrayFromBody(response));
            }
        }
        if (Utils.statusCodeMatches(response.statusCode(), "429")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                TooManyRequestsResponse out = Utils.mapper().readValue(
                    response.body(),
                    new TypeReference<>() {
                    });
                throw out;
            } else {
                throw new SDKError(
                    response, 
                    response.statusCode(), 
                    "Unexpected content-type received: " + contentType, 
                    Utils.extractByteArrayFromBody(response));
            }
        }
        if (Utils.statusCodeMatches(response.statusCode(), "500")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                InternalServerErrorResponse out = Utils.mapper().readValue(
                    response.body(),
                    new TypeReference<>() {
                    });
                throw out;
            } else {
                throw new SDKError(
                    response, 
                    response.statusCode(), 
                    "Unexpected content-type received: " + contentType, 
                    Utils.extractByteArrayFromBody(response));
            }
        }
        if (Utils.statusCodeMatches(response.statusCode(), "501")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                NotImplementedResponse out = Utils.mapper().readValue(
                    response.body(),
                    new TypeReference<>() {
                    });
                throw out;
            } else {
                throw new SDKError(
                    response, 
                    response.statusCode(), 
                    "Unexpected content-type received: " + contentType, 
                    Utils.extractByteArrayFromBody(response));
            }
        }
        if (Utils.statusCodeMatches(response.statusCode(), "502")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                BadGatewayResponse out = Utils.mapper().readValue(
                    response.body(),
                    new TypeReference<>() {
                    });
                throw out;
            } else {
                throw new SDKError(
                    response, 
                    response.statusCode(), 
                    "Unexpected content-type received: " + contentType, 
                    Utils.extractByteArrayFromBody(response));
            }
        }
        if (Utils.statusCodeMatches(response.statusCode(), "4XX")) {
            // no content 
            throw new SDKError(
                    response, 
                    response.statusCode(), 
                    "API error occurred", 
                    Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "5XX")) {
            // no content 
            throw new SDKError(
                    response, 
                    response.statusCode(), 
                    "API error occurred", 
                    Utils.extractByteArrayFromBody(response));
        }
        throw new SDKError(
            response, 
            response.statusCode(), 
            "Unexpected status code received: " + response.statusCode(), 
            Utils.extractByteArrayFromBody(response));
    }
}
