/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.ConnectorsMetaCategory;
import com.stackone.stackone_client_java.models.components.Resources;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;

public class ConnectorsMeta {
    @JsonProperty(value="provider")
    private String provider;
    @JsonProperty(value="provider_name")
    private String providerName;
    @JsonProperty(value="category")
    private ConnectorsMetaCategory category;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="active")
    private JsonNullable<Boolean> active;
    @JsonProperty(value="models")
    private Map<String, Object> models;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="resources")
    private JsonNullable<? extends Resources> resources;

    @JsonCreator
    public ConnectorsMeta(@JsonProperty(value="provider") String provider, @JsonProperty(value="provider_name") String providerName, @JsonProperty(value="category") ConnectorsMetaCategory category, @JsonProperty(value="active") JsonNullable<Boolean> active, @JsonProperty(value="models") Map<String, Object> models, @JsonProperty(value="resources") JsonNullable<? extends Resources> resources) {
        Utils.checkNotNull(provider, "provider");
        Utils.checkNotNull(providerName, "providerName");
        Utils.checkNotNull(category, "category");
        Utils.checkNotNull(active, "active");
        models = Utils.emptyMapIfNull(models);
        Utils.checkNotNull(resources, "resources");
        this.provider = provider;
        this.providerName = providerName;
        this.category = category;
        this.active = active;
        this.models = models;
        this.resources = resources;
    }

    public ConnectorsMeta(String provider, String providerName, ConnectorsMetaCategory category, Map<String, Object> models) {
        this(provider, providerName, category, (JsonNullable<Boolean>)JsonNullable.undefined(), models, (JsonNullable<? extends Resources>)JsonNullable.undefined());
    }

    @JsonIgnore
    public String provider() {
        return this.provider;
    }

    @JsonIgnore
    public String providerName() {
        return this.providerName;
    }

    @JsonIgnore
    public ConnectorsMetaCategory category() {
        return this.category;
    }

    @JsonIgnore
    public JsonNullable<Boolean> active() {
        return this.active;
    }

    @JsonIgnore
    public Map<String, Object> models() {
        return this.models;
    }

    @JsonIgnore
    public JsonNullable<Resources> resources() {
        return this.resources;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public ConnectorsMeta withProvider(String provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = provider;
        return this;
    }

    public ConnectorsMeta withProviderName(String providerName) {
        Utils.checkNotNull(providerName, "providerName");
        this.providerName = providerName;
        return this;
    }

    public ConnectorsMeta withCategory(ConnectorsMetaCategory category) {
        Utils.checkNotNull(category, "category");
        this.category = category;
        return this;
    }

    public ConnectorsMeta withActive(boolean active) {
        Utils.checkNotNull(active, "active");
        this.active = JsonNullable.of((Object)active);
        return this;
    }

    public ConnectorsMeta withActive(JsonNullable<Boolean> active) {
        Utils.checkNotNull(active, "active");
        this.active = active;
        return this;
    }

    public ConnectorsMeta withModels(Map<String, Object> models) {
        Utils.checkNotNull(models, "models");
        this.models = models;
        return this;
    }

    public ConnectorsMeta withResources(Resources resources) {
        Utils.checkNotNull(resources, "resources");
        this.resources = JsonNullable.of((Object)resources);
        return this;
    }

    public ConnectorsMeta withResources(JsonNullable<? extends Resources> resources) {
        Utils.checkNotNull(resources, "resources");
        this.resources = resources;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectorsMeta other = (ConnectorsMeta)o;
        return Utils.enhancedDeepEquals(this.provider, other.provider) && Utils.enhancedDeepEquals(this.providerName, other.providerName) && Utils.enhancedDeepEquals(this.category, other.category) && Utils.enhancedDeepEquals(this.active, other.active) && Utils.enhancedDeepEquals(this.models, other.models) && Utils.enhancedDeepEquals(this.resources, other.resources);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.provider, this.providerName, this.category, this.active, this.models, this.resources);
    }

    public String toString() {
        return Utils.toString(ConnectorsMeta.class, "provider", this.provider, "providerName", this.providerName, "category", this.category, "active", this.active, "models", this.models, "resources", this.resources);
    }

    public static final class Builder {
        private String provider;
        private String providerName;
        private ConnectorsMetaCategory category;
        private JsonNullable<Boolean> active = JsonNullable.undefined();
        private Map<String, Object> models;
        private JsonNullable<? extends Resources> resources = JsonNullable.undefined();

        private Builder() {
        }

        public Builder provider(String provider) {
            Utils.checkNotNull(provider, "provider");
            this.provider = provider;
            return this;
        }

        public Builder providerName(String providerName) {
            Utils.checkNotNull(providerName, "providerName");
            this.providerName = providerName;
            return this;
        }

        public Builder category(ConnectorsMetaCategory category) {
            Utils.checkNotNull(category, "category");
            this.category = category;
            return this;
        }

        public Builder active(boolean active) {
            Utils.checkNotNull(active, "active");
            this.active = JsonNullable.of((Object)active);
            return this;
        }

        public Builder active(JsonNullable<Boolean> active) {
            Utils.checkNotNull(active, "active");
            this.active = active;
            return this;
        }

        public Builder models(Map<String, Object> models) {
            Utils.checkNotNull(models, "models");
            this.models = models;
            return this;
        }

        public Builder resources(Resources resources) {
            Utils.checkNotNull(resources, "resources");
            this.resources = JsonNullable.of((Object)resources);
            return this;
        }

        public Builder resources(JsonNullable<? extends Resources> resources) {
            Utils.checkNotNull(resources, "resources");
            this.resources = resources;
            return this;
        }

        public ConnectorsMeta build() {
            return new ConnectorsMeta(this.provider, this.providerName, this.category, this.active, this.models, this.resources);
        }
    }
}

