/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HrisDocumentResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisGetEmployeeDocumentResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends HrisDocumentResult> hrisDocumentResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisGetEmployeeDocumentResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends HrisDocumentResult> hrisDocumentResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(hrisDocumentResult, "hrisDocumentResult");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.hrisDocumentResult = hrisDocumentResult;
        this.headers = headers;
    }

    public HrisGetEmployeeDocumentResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<HrisDocumentResult> hrisDocumentResult() {
        return this.hrisDocumentResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public HrisGetEmployeeDocumentResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisGetEmployeeDocumentResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisGetEmployeeDocumentResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisGetEmployeeDocumentResponse withHrisDocumentResult(HrisDocumentResult hrisDocumentResult) {
        Utils.checkNotNull(hrisDocumentResult, "hrisDocumentResult");
        this.hrisDocumentResult = Optional.ofNullable(hrisDocumentResult);
        return this;
    }

    public HrisGetEmployeeDocumentResponse withHrisDocumentResult(Optional<? extends HrisDocumentResult> hrisDocumentResult) {
        Utils.checkNotNull(hrisDocumentResult, "hrisDocumentResult");
        this.hrisDocumentResult = hrisDocumentResult;
        return this;
    }

    public HrisGetEmployeeDocumentResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisGetEmployeeDocumentResponse other = (HrisGetEmployeeDocumentResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.hrisDocumentResult, other.hrisDocumentResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.hrisDocumentResult, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisGetEmployeeDocumentResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "hrisDocumentResult", this.hrisDocumentResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends HrisDocumentResult> hrisDocumentResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder hrisDocumentResult(HrisDocumentResult hrisDocumentResult) {
            Utils.checkNotNull(hrisDocumentResult, "hrisDocumentResult");
            this.hrisDocumentResult = Optional.ofNullable(hrisDocumentResult);
            return this;
        }

        public Builder hrisDocumentResult(Optional<? extends HrisDocumentResult> hrisDocumentResult) {
            Utils.checkNotNull(hrisDocumentResult, "hrisDocumentResult");
            this.hrisDocumentResult = hrisDocumentResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisGetEmployeeDocumentResponse build() {
            return new HrisGetEmployeeDocumentResponse(this.contentType, this.statusCode, this.rawResponse, this.hrisDocumentResult, this.headers);
        }
    }
}

