/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * LmsListCoursesQueryParamFilter
 * 
 * <p>LMS Courses Filter
 */
public class LmsListCoursesQueryParamFilter {
    /**
     * Use a string with a date to only select results updated after that given date
     */
    @SpeakeasyMetadata("queryParam:name=updated_after")
    private JsonNullable<String> updatedAfter;

    /**
     * Filter to select courses by external_reference
     */
    @SpeakeasyMetadata("queryParam:name=external_reference")
    private JsonNullable<String> externalReference;

    @JsonCreator
    public LmsListCoursesQueryParamFilter(
            JsonNullable<String> updatedAfter,
            JsonNullable<String> externalReference) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        Utils.checkNotNull(externalReference, "externalReference");
        this.updatedAfter = updatedAfter;
        this.externalReference = externalReference;
    }
    
    public LmsListCoursesQueryParamFilter() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    @JsonIgnore
    public JsonNullable<String> updatedAfter() {
        return updatedAfter;
    }

    /**
     * Filter to select courses by external_reference
     */
    @JsonIgnore
    public JsonNullable<String> externalReference() {
        return externalReference;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Use a string with a date to only select results updated after that given date
     */
    public LmsListCoursesQueryParamFilter withUpdatedAfter(String updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = JsonNullable.of(updatedAfter);
        return this;
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    public LmsListCoursesQueryParamFilter withUpdatedAfter(JsonNullable<String> updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = updatedAfter;
        return this;
    }

    /**
     * Filter to select courses by external_reference
     */
    public LmsListCoursesQueryParamFilter withExternalReference(String externalReference) {
        Utils.checkNotNull(externalReference, "externalReference");
        this.externalReference = JsonNullable.of(externalReference);
        return this;
    }

    /**
     * Filter to select courses by external_reference
     */
    public LmsListCoursesQueryParamFilter withExternalReference(JsonNullable<String> externalReference) {
        Utils.checkNotNull(externalReference, "externalReference");
        this.externalReference = externalReference;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LmsListCoursesQueryParamFilter other = (LmsListCoursesQueryParamFilter) o;
        return 
            Utils.enhancedDeepEquals(this.updatedAfter, other.updatedAfter) &&
            Utils.enhancedDeepEquals(this.externalReference, other.externalReference);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            updatedAfter, externalReference);
    }
    
    @Override
    public String toString() {
        return Utils.toString(LmsListCoursesQueryParamFilter.class,
                "updatedAfter", updatedAfter,
                "externalReference", externalReference);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> updatedAfter = JsonNullable.undefined();

        private JsonNullable<String> externalReference = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(String updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = JsonNullable.of(updatedAfter);
            return this;
        }

        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(JsonNullable<String> updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = updatedAfter;
            return this;
        }


        /**
         * Filter to select courses by external_reference
         */
        public Builder externalReference(String externalReference) {
            Utils.checkNotNull(externalReference, "externalReference");
            this.externalReference = JsonNullable.of(externalReference);
            return this;
        }

        /**
         * Filter to select courses by external_reference
         */
        public Builder externalReference(JsonNullable<String> externalReference) {
            Utils.checkNotNull(externalReference, "externalReference");
            this.externalReference = externalReference;
            return this;
        }

        public LmsListCoursesQueryParamFilter build() {

            return new LmsListCoursesQueryParamFilter(
                updatedAfter, externalReference);
        }

    }
}
