/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.AtsListJobsRequest;
import com.stackone.stackone_client_java.models.operations.AtsListJobsResponse;
import com.stackone.stackone_client_java.operations.AtsListJobsOperation;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class AtsListJobsRequestBuilder {
    private AtsListJobsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public AtsListJobsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AtsListJobsRequestBuilder request(AtsListJobsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public AtsListJobsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AtsListJobsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public AtsListJobsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AtsListJobsOperation operation = new AtsListJobsOperation(this.sdkConfiguration, options);
        return (AtsListJobsResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<AtsListJobsResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AtsListJobsOperation operation = new AtsListJobsOperation(this.sdkConfiguration, options);
        Paginator<AtsListJobsRequest, String> iterator = new Paginator<AtsListJobsRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), AtsListJobsRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<AtsListJobsResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

