/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;


public class LmsCreateCompletionRequestDto {
    /**
     * Value to pass through to the provider
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("passthrough")
    private JsonNullable<? extends Map<String, Object>> passthrough;

    /**
     * The result of the completion
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("result")
    private JsonNullable<? extends LmsCreateCompletionRequestDtoResult> result;

    /**
     * The date the content was completed
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("completed_at")
    private JsonNullable<String> completedAt;

    /**
     * The id of the learning object associated with this completion. This is not required unless specified in an integration.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("learning_object_id")
    private JsonNullable<String> learningObjectId;

    /**
     * The external reference of the learning object associated with this completion, this is the main identifier for creating completions.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("learning_object_external_reference")
    private JsonNullable<String> learningObjectExternalReference;

    /**
     * ISO 8601 duration format representing the time spent on completing the learning object
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("time_spent")
    private JsonNullable<String> timeSpent;

    /**
     * The external reference associated with this content
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("content_external_reference")
    @Deprecated
    private JsonNullable<String> contentExternalReference;

    /**
     * The content ID associated with this completion
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("content_id")
    @Deprecated
    private JsonNullable<String> contentId;

    @JsonCreator
    public LmsCreateCompletionRequestDto(
            @JsonProperty("passthrough") JsonNullable<? extends Map<String, Object>> passthrough,
            @JsonProperty("result") JsonNullable<? extends LmsCreateCompletionRequestDtoResult> result,
            @JsonProperty("completed_at") JsonNullable<String> completedAt,
            @JsonProperty("learning_object_id") JsonNullable<String> learningObjectId,
            @JsonProperty("learning_object_external_reference") JsonNullable<String> learningObjectExternalReference,
            @JsonProperty("time_spent") JsonNullable<String> timeSpent,
            @JsonProperty("content_external_reference") JsonNullable<String> contentExternalReference,
            @JsonProperty("content_id") JsonNullable<String> contentId) {
        Utils.checkNotNull(passthrough, "passthrough");
        Utils.checkNotNull(result, "result");
        Utils.checkNotNull(completedAt, "completedAt");
        Utils.checkNotNull(learningObjectId, "learningObjectId");
        Utils.checkNotNull(learningObjectExternalReference, "learningObjectExternalReference");
        Utils.checkNotNull(timeSpent, "timeSpent");
        Utils.checkNotNull(contentExternalReference, "contentExternalReference");
        Utils.checkNotNull(contentId, "contentId");
        this.passthrough = passthrough;
        this.result = result;
        this.completedAt = completedAt;
        this.learningObjectId = learningObjectId;
        this.learningObjectExternalReference = learningObjectExternalReference;
        this.timeSpent = timeSpent;
        this.contentExternalReference = contentExternalReference;
        this.contentId = contentId;
    }
    
    public LmsCreateCompletionRequestDto() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Value to pass through to the provider
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> passthrough() {
        return (JsonNullable<Map<String, Object>>) passthrough;
    }

    /**
     * The result of the completion
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<LmsCreateCompletionRequestDtoResult> result() {
        return (JsonNullable<LmsCreateCompletionRequestDtoResult>) result;
    }

    /**
     * The date the content was completed
     */
    @JsonIgnore
    public JsonNullable<String> completedAt() {
        return completedAt;
    }

    /**
     * The id of the learning object associated with this completion. This is not required unless specified in an integration.
     */
    @JsonIgnore
    public JsonNullable<String> learningObjectId() {
        return learningObjectId;
    }

    /**
     * The external reference of the learning object associated with this completion, this is the main identifier for creating completions.
     */
    @JsonIgnore
    public JsonNullable<String> learningObjectExternalReference() {
        return learningObjectExternalReference;
    }

    /**
     * ISO 8601 duration format representing the time spent on completing the learning object
     */
    @JsonIgnore
    public JsonNullable<String> timeSpent() {
        return timeSpent;
    }

    /**
     * The external reference associated with this content
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @JsonIgnore
    public JsonNullable<String> contentExternalReference() {
        return contentExternalReference;
    }

    /**
     * The content ID associated with this completion
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @JsonIgnore
    public JsonNullable<String> contentId() {
        return contentId;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Value to pass through to the provider
     */
    public LmsCreateCompletionRequestDto withPassthrough(Map<String, Object> passthrough) {
        Utils.checkNotNull(passthrough, "passthrough");
        this.passthrough = JsonNullable.of(passthrough);
        return this;
    }

    /**
     * Value to pass through to the provider
     */
    public LmsCreateCompletionRequestDto withPassthrough(JsonNullable<? extends Map<String, Object>> passthrough) {
        Utils.checkNotNull(passthrough, "passthrough");
        this.passthrough = passthrough;
        return this;
    }

    /**
     * The result of the completion
     */
    public LmsCreateCompletionRequestDto withResult(LmsCreateCompletionRequestDtoResult result) {
        Utils.checkNotNull(result, "result");
        this.result = JsonNullable.of(result);
        return this;
    }

    /**
     * The result of the completion
     */
    public LmsCreateCompletionRequestDto withResult(JsonNullable<? extends LmsCreateCompletionRequestDtoResult> result) {
        Utils.checkNotNull(result, "result");
        this.result = result;
        return this;
    }

    /**
     * The date the content was completed
     */
    public LmsCreateCompletionRequestDto withCompletedAt(String completedAt) {
        Utils.checkNotNull(completedAt, "completedAt");
        this.completedAt = JsonNullable.of(completedAt);
        return this;
    }

    /**
     * The date the content was completed
     */
    public LmsCreateCompletionRequestDto withCompletedAt(JsonNullable<String> completedAt) {
        Utils.checkNotNull(completedAt, "completedAt");
        this.completedAt = completedAt;
        return this;
    }

    /**
     * The id of the learning object associated with this completion. This is not required unless specified in an integration.
     */
    public LmsCreateCompletionRequestDto withLearningObjectId(String learningObjectId) {
        Utils.checkNotNull(learningObjectId, "learningObjectId");
        this.learningObjectId = JsonNullable.of(learningObjectId);
        return this;
    }

    /**
     * The id of the learning object associated with this completion. This is not required unless specified in an integration.
     */
    public LmsCreateCompletionRequestDto withLearningObjectId(JsonNullable<String> learningObjectId) {
        Utils.checkNotNull(learningObjectId, "learningObjectId");
        this.learningObjectId = learningObjectId;
        return this;
    }

    /**
     * The external reference of the learning object associated with this completion, this is the main identifier for creating completions.
     */
    public LmsCreateCompletionRequestDto withLearningObjectExternalReference(String learningObjectExternalReference) {
        Utils.checkNotNull(learningObjectExternalReference, "learningObjectExternalReference");
        this.learningObjectExternalReference = JsonNullable.of(learningObjectExternalReference);
        return this;
    }

    /**
     * The external reference of the learning object associated with this completion, this is the main identifier for creating completions.
     */
    public LmsCreateCompletionRequestDto withLearningObjectExternalReference(JsonNullable<String> learningObjectExternalReference) {
        Utils.checkNotNull(learningObjectExternalReference, "learningObjectExternalReference");
        this.learningObjectExternalReference = learningObjectExternalReference;
        return this;
    }

    /**
     * ISO 8601 duration format representing the time spent on completing the learning object
     */
    public LmsCreateCompletionRequestDto withTimeSpent(String timeSpent) {
        Utils.checkNotNull(timeSpent, "timeSpent");
        this.timeSpent = JsonNullable.of(timeSpent);
        return this;
    }

    /**
     * ISO 8601 duration format representing the time spent on completing the learning object
     */
    public LmsCreateCompletionRequestDto withTimeSpent(JsonNullable<String> timeSpent) {
        Utils.checkNotNull(timeSpent, "timeSpent");
        this.timeSpent = timeSpent;
        return this;
    }

    /**
     * The external reference associated with this content
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public LmsCreateCompletionRequestDto withContentExternalReference(String contentExternalReference) {
        Utils.checkNotNull(contentExternalReference, "contentExternalReference");
        this.contentExternalReference = JsonNullable.of(contentExternalReference);
        return this;
    }

    /**
     * The external reference associated with this content
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public LmsCreateCompletionRequestDto withContentExternalReference(JsonNullable<String> contentExternalReference) {
        Utils.checkNotNull(contentExternalReference, "contentExternalReference");
        this.contentExternalReference = contentExternalReference;
        return this;
    }

    /**
     * The content ID associated with this completion
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public LmsCreateCompletionRequestDto withContentId(String contentId) {
        Utils.checkNotNull(contentId, "contentId");
        this.contentId = JsonNullable.of(contentId);
        return this;
    }

    /**
     * The content ID associated with this completion
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public LmsCreateCompletionRequestDto withContentId(JsonNullable<String> contentId) {
        Utils.checkNotNull(contentId, "contentId");
        this.contentId = contentId;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LmsCreateCompletionRequestDto other = (LmsCreateCompletionRequestDto) o;
        return 
            Utils.enhancedDeepEquals(this.passthrough, other.passthrough) &&
            Utils.enhancedDeepEquals(this.result, other.result) &&
            Utils.enhancedDeepEquals(this.completedAt, other.completedAt) &&
            Utils.enhancedDeepEquals(this.learningObjectId, other.learningObjectId) &&
            Utils.enhancedDeepEquals(this.learningObjectExternalReference, other.learningObjectExternalReference) &&
            Utils.enhancedDeepEquals(this.timeSpent, other.timeSpent) &&
            Utils.enhancedDeepEquals(this.contentExternalReference, other.contentExternalReference) &&
            Utils.enhancedDeepEquals(this.contentId, other.contentId);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            passthrough, result, completedAt,
            learningObjectId, learningObjectExternalReference, timeSpent,
            contentExternalReference, contentId);
    }
    
    @Override
    public String toString() {
        return Utils.toString(LmsCreateCompletionRequestDto.class,
                "passthrough", passthrough,
                "result", result,
                "completedAt", completedAt,
                "learningObjectId", learningObjectId,
                "learningObjectExternalReference", learningObjectExternalReference,
                "timeSpent", timeSpent,
                "contentExternalReference", contentExternalReference,
                "contentId", contentId);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends Map<String, Object>> passthrough = JsonNullable.undefined();

        private JsonNullable<? extends LmsCreateCompletionRequestDtoResult> result = JsonNullable.undefined();

        private JsonNullable<String> completedAt = JsonNullable.undefined();

        private JsonNullable<String> learningObjectId = JsonNullable.undefined();

        private JsonNullable<String> learningObjectExternalReference = JsonNullable.undefined();

        private JsonNullable<String> timeSpent = JsonNullable.undefined();

        @Deprecated
        private JsonNullable<String> contentExternalReference = JsonNullable.undefined();

        @Deprecated
        private JsonNullable<String> contentId = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Value to pass through to the provider
         */
        public Builder passthrough(Map<String, Object> passthrough) {
            Utils.checkNotNull(passthrough, "passthrough");
            this.passthrough = JsonNullable.of(passthrough);
            return this;
        }

        /**
         * Value to pass through to the provider
         */
        public Builder passthrough(JsonNullable<? extends Map<String, Object>> passthrough) {
            Utils.checkNotNull(passthrough, "passthrough");
            this.passthrough = passthrough;
            return this;
        }


        /**
         * The result of the completion
         */
        public Builder result(LmsCreateCompletionRequestDtoResult result) {
            Utils.checkNotNull(result, "result");
            this.result = JsonNullable.of(result);
            return this;
        }

        /**
         * The result of the completion
         */
        public Builder result(JsonNullable<? extends LmsCreateCompletionRequestDtoResult> result) {
            Utils.checkNotNull(result, "result");
            this.result = result;
            return this;
        }


        /**
         * The date the content was completed
         */
        public Builder completedAt(String completedAt) {
            Utils.checkNotNull(completedAt, "completedAt");
            this.completedAt = JsonNullable.of(completedAt);
            return this;
        }

        /**
         * The date the content was completed
         */
        public Builder completedAt(JsonNullable<String> completedAt) {
            Utils.checkNotNull(completedAt, "completedAt");
            this.completedAt = completedAt;
            return this;
        }


        /**
         * The id of the learning object associated with this completion. This is not required unless specified in an integration.
         */
        public Builder learningObjectId(String learningObjectId) {
            Utils.checkNotNull(learningObjectId, "learningObjectId");
            this.learningObjectId = JsonNullable.of(learningObjectId);
            return this;
        }

        /**
         * The id of the learning object associated with this completion. This is not required unless specified in an integration.
         */
        public Builder learningObjectId(JsonNullable<String> learningObjectId) {
            Utils.checkNotNull(learningObjectId, "learningObjectId");
            this.learningObjectId = learningObjectId;
            return this;
        }


        /**
         * The external reference of the learning object associated with this completion, this is the main identifier for creating completions.
         */
        public Builder learningObjectExternalReference(String learningObjectExternalReference) {
            Utils.checkNotNull(learningObjectExternalReference, "learningObjectExternalReference");
            this.learningObjectExternalReference = JsonNullable.of(learningObjectExternalReference);
            return this;
        }

        /**
         * The external reference of the learning object associated with this completion, this is the main identifier for creating completions.
         */
        public Builder learningObjectExternalReference(JsonNullable<String> learningObjectExternalReference) {
            Utils.checkNotNull(learningObjectExternalReference, "learningObjectExternalReference");
            this.learningObjectExternalReference = learningObjectExternalReference;
            return this;
        }


        /**
         * ISO 8601 duration format representing the time spent on completing the learning object
         */
        public Builder timeSpent(String timeSpent) {
            Utils.checkNotNull(timeSpent, "timeSpent");
            this.timeSpent = JsonNullable.of(timeSpent);
            return this;
        }

        /**
         * ISO 8601 duration format representing the time spent on completing the learning object
         */
        public Builder timeSpent(JsonNullable<String> timeSpent) {
            Utils.checkNotNull(timeSpent, "timeSpent");
            this.timeSpent = timeSpent;
            return this;
        }


        /**
         * The external reference associated with this content
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder contentExternalReference(String contentExternalReference) {
            Utils.checkNotNull(contentExternalReference, "contentExternalReference");
            this.contentExternalReference = JsonNullable.of(contentExternalReference);
            return this;
        }

        /**
         * The external reference associated with this content
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder contentExternalReference(JsonNullable<String> contentExternalReference) {
            Utils.checkNotNull(contentExternalReference, "contentExternalReference");
            this.contentExternalReference = contentExternalReference;
            return this;
        }


        /**
         * The content ID associated with this completion
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder contentId(String contentId) {
            Utils.checkNotNull(contentId, "contentId");
            this.contentId = JsonNullable.of(contentId);
            return this;
        }

        /**
         * The content ID associated with this completion
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder contentId(JsonNullable<String> contentId) {
            Utils.checkNotNull(contentId, "contentId");
            this.contentId = contentId;
            return this;
        }

        public LmsCreateCompletionRequestDto build() {

            return new LmsCreateCompletionRequestDto(
                passthrough, result, completedAt,
                learningObjectId, learningObjectExternalReference, timeSpent,
                contentExternalReference, contentId);
        }

    }
}
