/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.HrisListCompaniesRequest;
import com.stackone.stackone_client_java.models.operations.HrisListCompaniesResponse;
import com.stackone.stackone_client_java.operations.HrisListCompaniesOperation;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class HrisListCompaniesRequestBuilder {
    private HrisListCompaniesRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public HrisListCompaniesRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public HrisListCompaniesRequestBuilder request(HrisListCompaniesRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public HrisListCompaniesRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public HrisListCompaniesRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public HrisListCompaniesResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        HrisListCompaniesOperation operation = new HrisListCompaniesOperation(this.sdkConfiguration, options);
        return (HrisListCompaniesResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<HrisListCompaniesResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        HrisListCompaniesOperation operation = new HrisListCompaniesOperation(this.sdkConfiguration, options);
        Paginator<HrisListCompaniesRequest, String> iterator = new Paginator<HrisListCompaniesRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), HrisListCompaniesRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<HrisListCompaniesResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

