/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.PatchAccountExternalDto;
import com.stackone.stackone_client_java.models.operations.StackoneUpdateAccountRequest;
import com.stackone.stackone_client_java.models.operations.StackoneUpdateAccountResponse;
import com.stackone.stackone_client_java.operations.StackoneUpdateAccountOperation;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class StackoneUpdateAccountRequestBuilder {
    private String id;
    private PatchAccountExternalDto patchAccountExternalDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public StackoneUpdateAccountRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public StackoneUpdateAccountRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public StackoneUpdateAccountRequestBuilder patchAccountExternalDto(PatchAccountExternalDto patchAccountExternalDto) {
        Utils.checkNotNull(patchAccountExternalDto, "patchAccountExternalDto");
        this.patchAccountExternalDto = patchAccountExternalDto;
        return this;
    }

    public StackoneUpdateAccountRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public StackoneUpdateAccountRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private StackoneUpdateAccountRequest buildRequest() {
        StackoneUpdateAccountRequest request = new StackoneUpdateAccountRequest(this.id, this.patchAccountExternalDto);
        return request;
    }

    public StackoneUpdateAccountResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        StackoneUpdateAccountOperation operation = new StackoneUpdateAccountOperation(this.sdkConfiguration, options);
        StackoneUpdateAccountRequest request = this.buildRequest();
        return (StackoneUpdateAccountResponse)operation.handleResponse(operation.doRequest(request));
    }
}

