/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;


public class AccountingCompany {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * Name of the company
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    /**
     * Default currency for the company
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("base_currency")
    private JsonNullable<? extends BaseCurrency> baseCurrency;

    /**
     * Fiscal year start month (1-12)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("fiscal_year_start_month")
    private JsonNullable<Double> fiscalYearStartMonth;

    /**
     * Fiscal year start day (1-31)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("fiscal_year_start_day")
    private JsonNullable<Double> fiscalYearStartDay;

    @JsonCreator
    public AccountingCompany(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("base_currency") JsonNullable<? extends BaseCurrency> baseCurrency,
            @JsonProperty("fiscal_year_start_month") JsonNullable<Double> fiscalYearStartMonth,
            @JsonProperty("fiscal_year_start_day") JsonNullable<Double> fiscalYearStartDay) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(baseCurrency, "baseCurrency");
        Utils.checkNotNull(fiscalYearStartMonth, "fiscalYearStartMonth");
        Utils.checkNotNull(fiscalYearStartDay, "fiscalYearStartDay");
        this.id = id;
        this.remoteId = remoteId;
        this.name = name;
        this.baseCurrency = baseCurrency;
        this.fiscalYearStartMonth = fiscalYearStartMonth;
        this.fiscalYearStartDay = fiscalYearStartDay;
    }
    
    public AccountingCompany() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * Name of the company
     */
    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    /**
     * Default currency for the company
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<BaseCurrency> baseCurrency() {
        return (JsonNullable<BaseCurrency>) baseCurrency;
    }

    /**
     * Fiscal year start month (1-12)
     */
    @JsonIgnore
    public JsonNullable<Double> fiscalYearStartMonth() {
        return fiscalYearStartMonth;
    }

    /**
     * Fiscal year start day (1-31)
     */
    @JsonIgnore
    public JsonNullable<Double> fiscalYearStartDay() {
        return fiscalYearStartDay;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public AccountingCompany withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public AccountingCompany withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public AccountingCompany withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public AccountingCompany withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * Name of the company
     */
    public AccountingCompany withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    /**
     * Name of the company
     */
    public AccountingCompany withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * Default currency for the company
     */
    public AccountingCompany withBaseCurrency(BaseCurrency baseCurrency) {
        Utils.checkNotNull(baseCurrency, "baseCurrency");
        this.baseCurrency = JsonNullable.of(baseCurrency);
        return this;
    }

    /**
     * Default currency for the company
     */
    public AccountingCompany withBaseCurrency(JsonNullable<? extends BaseCurrency> baseCurrency) {
        Utils.checkNotNull(baseCurrency, "baseCurrency");
        this.baseCurrency = baseCurrency;
        return this;
    }

    /**
     * Fiscal year start month (1-12)
     */
    public AccountingCompany withFiscalYearStartMonth(double fiscalYearStartMonth) {
        Utils.checkNotNull(fiscalYearStartMonth, "fiscalYearStartMonth");
        this.fiscalYearStartMonth = JsonNullable.of(fiscalYearStartMonth);
        return this;
    }

    /**
     * Fiscal year start month (1-12)
     */
    public AccountingCompany withFiscalYearStartMonth(JsonNullable<Double> fiscalYearStartMonth) {
        Utils.checkNotNull(fiscalYearStartMonth, "fiscalYearStartMonth");
        this.fiscalYearStartMonth = fiscalYearStartMonth;
        return this;
    }

    /**
     * Fiscal year start day (1-31)
     */
    public AccountingCompany withFiscalYearStartDay(double fiscalYearStartDay) {
        Utils.checkNotNull(fiscalYearStartDay, "fiscalYearStartDay");
        this.fiscalYearStartDay = JsonNullable.of(fiscalYearStartDay);
        return this;
    }

    /**
     * Fiscal year start day (1-31)
     */
    public AccountingCompany withFiscalYearStartDay(JsonNullable<Double> fiscalYearStartDay) {
        Utils.checkNotNull(fiscalYearStartDay, "fiscalYearStartDay");
        this.fiscalYearStartDay = fiscalYearStartDay;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountingCompany other = (AccountingCompany) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.baseCurrency, other.baseCurrency) &&
            Utils.enhancedDeepEquals(this.fiscalYearStartMonth, other.fiscalYearStartMonth) &&
            Utils.enhancedDeepEquals(this.fiscalYearStartDay, other.fiscalYearStartDay);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, name,
            baseCurrency, fiscalYearStartMonth, fiscalYearStartDay);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AccountingCompany.class,
                "id", id,
                "remoteId", remoteId,
                "name", name,
                "baseCurrency", baseCurrency,
                "fiscalYearStartMonth", fiscalYearStartMonth,
                "fiscalYearStartDay", fiscalYearStartDay);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<String> name = JsonNullable.undefined();

        private JsonNullable<? extends BaseCurrency> baseCurrency = JsonNullable.undefined();

        private JsonNullable<Double> fiscalYearStartMonth = JsonNullable.undefined();

        private JsonNullable<Double> fiscalYearStartDay = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * Name of the company
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        /**
         * Name of the company
         */
        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }


        /**
         * Default currency for the company
         */
        public Builder baseCurrency(BaseCurrency baseCurrency) {
            Utils.checkNotNull(baseCurrency, "baseCurrency");
            this.baseCurrency = JsonNullable.of(baseCurrency);
            return this;
        }

        /**
         * Default currency for the company
         */
        public Builder baseCurrency(JsonNullable<? extends BaseCurrency> baseCurrency) {
            Utils.checkNotNull(baseCurrency, "baseCurrency");
            this.baseCurrency = baseCurrency;
            return this;
        }


        /**
         * Fiscal year start month (1-12)
         */
        public Builder fiscalYearStartMonth(double fiscalYearStartMonth) {
            Utils.checkNotNull(fiscalYearStartMonth, "fiscalYearStartMonth");
            this.fiscalYearStartMonth = JsonNullable.of(fiscalYearStartMonth);
            return this;
        }

        /**
         * Fiscal year start month (1-12)
         */
        public Builder fiscalYearStartMonth(JsonNullable<Double> fiscalYearStartMonth) {
            Utils.checkNotNull(fiscalYearStartMonth, "fiscalYearStartMonth");
            this.fiscalYearStartMonth = fiscalYearStartMonth;
            return this;
        }


        /**
         * Fiscal year start day (1-31)
         */
        public Builder fiscalYearStartDay(double fiscalYearStartDay) {
            Utils.checkNotNull(fiscalYearStartDay, "fiscalYearStartDay");
            this.fiscalYearStartDay = JsonNullable.of(fiscalYearStartDay);
            return this;
        }

        /**
         * Fiscal year start day (1-31)
         */
        public Builder fiscalYearStartDay(JsonNullable<Double> fiscalYearStartDay) {
            Utils.checkNotNull(fiscalYearStartDay, "fiscalYearStartDay");
            this.fiscalYearStartDay = fiscalYearStartDay;
            return this;
        }

        public AccountingCompany build() {

            return new AccountingCompany(
                id, remoteId, name,
                baseCurrency, fiscalYearStartMonth, fiscalYearStartDay);
        }

    }
}
