/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * ChannelsEnumValue
 * 
 * <p>The Channels of the campaign.
 */
@JsonDeserialize(using = ChannelsEnumValue._Deserializer.class)
@JsonSerialize(using = ChannelsEnumValue._Serializer.class)
public class ChannelsEnumValue {

    public static final ChannelsEnumValue EMAIL = new ChannelsEnumValue("email");
    public static final ChannelsEnumValue SMS = new ChannelsEnumValue("sms");
    public static final ChannelsEnumValue WEB_PUSH = new ChannelsEnumValue("web_push");
    public static final ChannelsEnumValue IOS_PUSH = new ChannelsEnumValue("ios_push");
    public static final ChannelsEnumValue ANDROID_PUSH = new ChannelsEnumValue("android_push");
    public static final ChannelsEnumValue UNKNOWN = new ChannelsEnumValue("unknown");
    public static final ChannelsEnumValue UNMAPPED_VALUE = new ChannelsEnumValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, ChannelsEnumValue> values = createValuesMap();
    private static final Map<String, ChannelsEnumValueEnum> enums = createEnumsMap();

    private final String value;

    private ChannelsEnumValue(String value) {
        this.value = value;
    }

    /**
     * Returns a ChannelsEnumValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as ChannelsEnumValue
     */ 
    public static ChannelsEnumValue of(String value) {
        synchronized (ChannelsEnumValue.class) {
            return values.computeIfAbsent(value, v -> new ChannelsEnumValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<ChannelsEnumValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        ChannelsEnumValue other = (ChannelsEnumValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "ChannelsEnumValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static ChannelsEnumValue[] values() {
        synchronized (ChannelsEnumValue.class) {
            return values.values().toArray(new ChannelsEnumValue[] {});
        }
    }

    private static final Map<String, ChannelsEnumValue> createValuesMap() {
        Map<String, ChannelsEnumValue> map = new LinkedHashMap<>();
        map.put("email", EMAIL);
        map.put("sms", SMS);
        map.put("web_push", WEB_PUSH);
        map.put("ios_push", IOS_PUSH);
        map.put("android_push", ANDROID_PUSH);
        map.put("unknown", UNKNOWN);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, ChannelsEnumValueEnum> createEnumsMap() {
        Map<String, ChannelsEnumValueEnum> map = new HashMap<>();
        map.put("email", ChannelsEnumValueEnum.EMAIL);
        map.put("sms", ChannelsEnumValueEnum.SMS);
        map.put("web_push", ChannelsEnumValueEnum.WEB_PUSH);
        map.put("ios_push", ChannelsEnumValueEnum.IOS_PUSH);
        map.put("android_push", ChannelsEnumValueEnum.ANDROID_PUSH);
        map.put("unknown", ChannelsEnumValueEnum.UNKNOWN);
        map.put("unmapped_value", ChannelsEnumValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<ChannelsEnumValue> {

        protected _Serializer() {
            super(ChannelsEnumValue.class);
        }

        @Override
        public void serialize(ChannelsEnumValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<ChannelsEnumValue> {

        protected _Deserializer() {
            super(ChannelsEnumValue.class);
        }

        @Override
        public ChannelsEnumValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return ChannelsEnumValue.of(v);
        }
    }
    
    public enum ChannelsEnumValueEnum {

        EMAIL("email"),
        SMS("sms"),
        WEB_PUSH("web_push"),
        IOS_PUSH("ios_push"),
        ANDROID_PUSH("android_push"),
        UNKNOWN("unknown"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private ChannelsEnumValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

