/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;
import org.openapitools.jackson.nullable.JsonNullable;


public class CreateJournalLine {
    /**
     * ID of the ledger account this line references
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("account_id")
    private JsonNullable<String> accountId;

    /**
     * Description of the journal line
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("description")
    private JsonNullable<String> description;

    /**
     * Amount of the journal line in minor units, e.g. 10010 for 100.10 USD. Positive for debit, negative for credit
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("amount")
    private JsonNullable<Double> amount;

    /**
     * ID of the tax rate applied
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("tax_rate_id")
    private JsonNullable<String> taxRateId;

    /**
     * Tax amount of the line in minor units, e.g. 10010 for 100.10 USD
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("tax_amount")
    private JsonNullable<Double> taxAmount;

    @JsonCreator
    public CreateJournalLine(
            @JsonProperty("account_id") JsonNullable<String> accountId,
            @JsonProperty("description") JsonNullable<String> description,
            @JsonProperty("amount") JsonNullable<Double> amount,
            @JsonProperty("tax_rate_id") JsonNullable<String> taxRateId,
            @JsonProperty("tax_amount") JsonNullable<Double> taxAmount) {
        Utils.checkNotNull(accountId, "accountId");
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(amount, "amount");
        Utils.checkNotNull(taxRateId, "taxRateId");
        Utils.checkNotNull(taxAmount, "taxAmount");
        this.accountId = accountId;
        this.description = description;
        this.amount = amount;
        this.taxRateId = taxRateId;
        this.taxAmount = taxAmount;
    }
    
    public CreateJournalLine() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * ID of the ledger account this line references
     */
    @JsonIgnore
    public JsonNullable<String> accountId() {
        return accountId;
    }

    /**
     * Description of the journal line
     */
    @JsonIgnore
    public JsonNullable<String> description() {
        return description;
    }

    /**
     * Amount of the journal line in minor units, e.g. 10010 for 100.10 USD. Positive for debit, negative for credit
     */
    @JsonIgnore
    public JsonNullable<Double> amount() {
        return amount;
    }

    /**
     * ID of the tax rate applied
     */
    @JsonIgnore
    public JsonNullable<String> taxRateId() {
        return taxRateId;
    }

    /**
     * Tax amount of the line in minor units, e.g. 10010 for 100.10 USD
     */
    @JsonIgnore
    public JsonNullable<Double> taxAmount() {
        return taxAmount;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * ID of the ledger account this line references
     */
    public CreateJournalLine withAccountId(String accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = JsonNullable.of(accountId);
        return this;
    }

    /**
     * ID of the ledger account this line references
     */
    public CreateJournalLine withAccountId(JsonNullable<String> accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = accountId;
        return this;
    }

    /**
     * Description of the journal line
     */
    public CreateJournalLine withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = JsonNullable.of(description);
        return this;
    }

    /**
     * Description of the journal line
     */
    public CreateJournalLine withDescription(JsonNullable<String> description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    /**
     * Amount of the journal line in minor units, e.g. 10010 for 100.10 USD. Positive for debit, negative for credit
     */
    public CreateJournalLine withAmount(double amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = JsonNullable.of(amount);
        return this;
    }

    /**
     * Amount of the journal line in minor units, e.g. 10010 for 100.10 USD. Positive for debit, negative for credit
     */
    public CreateJournalLine withAmount(JsonNullable<Double> amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = amount;
        return this;
    }

    /**
     * ID of the tax rate applied
     */
    public CreateJournalLine withTaxRateId(String taxRateId) {
        Utils.checkNotNull(taxRateId, "taxRateId");
        this.taxRateId = JsonNullable.of(taxRateId);
        return this;
    }

    /**
     * ID of the tax rate applied
     */
    public CreateJournalLine withTaxRateId(JsonNullable<String> taxRateId) {
        Utils.checkNotNull(taxRateId, "taxRateId");
        this.taxRateId = taxRateId;
        return this;
    }

    /**
     * Tax amount of the line in minor units, e.g. 10010 for 100.10 USD
     */
    public CreateJournalLine withTaxAmount(double taxAmount) {
        Utils.checkNotNull(taxAmount, "taxAmount");
        this.taxAmount = JsonNullable.of(taxAmount);
        return this;
    }

    /**
     * Tax amount of the line in minor units, e.g. 10010 for 100.10 USD
     */
    public CreateJournalLine withTaxAmount(JsonNullable<Double> taxAmount) {
        Utils.checkNotNull(taxAmount, "taxAmount");
        this.taxAmount = taxAmount;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateJournalLine other = (CreateJournalLine) o;
        return 
            Utils.enhancedDeepEquals(this.accountId, other.accountId) &&
            Utils.enhancedDeepEquals(this.description, other.description) &&
            Utils.enhancedDeepEquals(this.amount, other.amount) &&
            Utils.enhancedDeepEquals(this.taxRateId, other.taxRateId) &&
            Utils.enhancedDeepEquals(this.taxAmount, other.taxAmount);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountId, description, amount,
            taxRateId, taxAmount);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateJournalLine.class,
                "accountId", accountId,
                "description", description,
                "amount", amount,
                "taxRateId", taxRateId,
                "taxAmount", taxAmount);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> accountId = JsonNullable.undefined();

        private JsonNullable<String> description = JsonNullable.undefined();

        private JsonNullable<Double> amount = JsonNullable.undefined();

        private JsonNullable<String> taxRateId = JsonNullable.undefined();

        private JsonNullable<Double> taxAmount = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * ID of the ledger account this line references
         */
        public Builder accountId(String accountId) {
            Utils.checkNotNull(accountId, "accountId");
            this.accountId = JsonNullable.of(accountId);
            return this;
        }

        /**
         * ID of the ledger account this line references
         */
        public Builder accountId(JsonNullable<String> accountId) {
            Utils.checkNotNull(accountId, "accountId");
            this.accountId = accountId;
            return this;
        }


        /**
         * Description of the journal line
         */
        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = JsonNullable.of(description);
            return this;
        }

        /**
         * Description of the journal line
         */
        public Builder description(JsonNullable<String> description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }


        /**
         * Amount of the journal line in minor units, e.g. 10010 for 100.10 USD. Positive for debit, negative for credit
         */
        public Builder amount(double amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = JsonNullable.of(amount);
            return this;
        }

        /**
         * Amount of the journal line in minor units, e.g. 10010 for 100.10 USD. Positive for debit, negative for credit
         */
        public Builder amount(JsonNullable<Double> amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = amount;
            return this;
        }


        /**
         * ID of the tax rate applied
         */
        public Builder taxRateId(String taxRateId) {
            Utils.checkNotNull(taxRateId, "taxRateId");
            this.taxRateId = JsonNullable.of(taxRateId);
            return this;
        }

        /**
         * ID of the tax rate applied
         */
        public Builder taxRateId(JsonNullable<String> taxRateId) {
            Utils.checkNotNull(taxRateId, "taxRateId");
            this.taxRateId = taxRateId;
            return this;
        }


        /**
         * Tax amount of the line in minor units, e.g. 10010 for 100.10 USD
         */
        public Builder taxAmount(double taxAmount) {
            Utils.checkNotNull(taxAmount, "taxAmount");
            this.taxAmount = JsonNullable.of(taxAmount);
            return this;
        }

        /**
         * Tax amount of the line in minor units, e.g. 10010 for 100.10 USD
         */
        public Builder taxAmount(JsonNullable<Double> taxAmount) {
            Utils.checkNotNull(taxAmount, "taxAmount");
            this.taxAmount = taxAmount;
            return this;
        }

        public CreateJournalLine build() {

            return new CreateJournalLine(
                accountId, description, amount,
                taxRateId, taxAmount);
        }

    }
}
