/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;


public class IamGroup {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("description")
    private JsonNullable<String> description;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("type")
    private JsonNullable<? extends IamGroupType> type;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("roles")
    private JsonNullable<? extends List<IamRole>> roles;

    /**
     * The parent group id for when a group belongs to another group.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("parent_id")
    private JsonNullable<String> parentId;

    /**
     * Provider's unique identifier of the parent group id for when a group belongs to another group.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_parent_id")
    private JsonNullable<String> remoteParentId;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    @JsonCreator
    public IamGroup(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("description") JsonNullable<String> description,
            @JsonProperty("type") JsonNullable<? extends IamGroupType> type,
            @JsonProperty("roles") JsonNullable<? extends List<IamRole>> roles,
            @JsonProperty("parent_id") JsonNullable<String> parentId,
            @JsonProperty("remote_parent_id") JsonNullable<String> remoteParentId,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(roles, "roles");
        Utils.checkNotNull(parentId, "parentId");
        Utils.checkNotNull(remoteParentId, "remoteParentId");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.id = id;
        this.remoteId = remoteId;
        this.name = name;
        this.description = description;
        this.type = type;
        this.roles = roles;
        this.parentId = parentId;
        this.remoteParentId = remoteParentId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }
    
    public IamGroup() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    @JsonIgnore
    public JsonNullable<String> description() {
        return description;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<IamGroupType> type() {
        return (JsonNullable<IamGroupType>) type;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<IamRole>> roles() {
        return (JsonNullable<List<IamRole>>) roles;
    }

    /**
     * The parent group id for when a group belongs to another group.
     */
    @JsonIgnore
    public JsonNullable<String> parentId() {
        return parentId;
    }

    /**
     * Provider's unique identifier of the parent group id for when a group belongs to another group.
     */
    @JsonIgnore
    public JsonNullable<String> remoteParentId() {
        return remoteParentId;
    }

    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public IamGroup withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public IamGroup withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public IamGroup withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public IamGroup withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    public IamGroup withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    public IamGroup withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public IamGroup withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = JsonNullable.of(description);
        return this;
    }

    public IamGroup withDescription(JsonNullable<String> description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    public IamGroup withType(IamGroupType type) {
        Utils.checkNotNull(type, "type");
        this.type = JsonNullable.of(type);
        return this;
    }

    public IamGroup withType(JsonNullable<? extends IamGroupType> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    public IamGroup withRoles(List<IamRole> roles) {
        Utils.checkNotNull(roles, "roles");
        this.roles = JsonNullable.of(roles);
        return this;
    }

    public IamGroup withRoles(JsonNullable<? extends List<IamRole>> roles) {
        Utils.checkNotNull(roles, "roles");
        this.roles = roles;
        return this;
    }

    /**
     * The parent group id for when a group belongs to another group.
     */
    public IamGroup withParentId(String parentId) {
        Utils.checkNotNull(parentId, "parentId");
        this.parentId = JsonNullable.of(parentId);
        return this;
    }

    /**
     * The parent group id for when a group belongs to another group.
     */
    public IamGroup withParentId(JsonNullable<String> parentId) {
        Utils.checkNotNull(parentId, "parentId");
        this.parentId = parentId;
        return this;
    }

    /**
     * Provider's unique identifier of the parent group id for when a group belongs to another group.
     */
    public IamGroup withRemoteParentId(String remoteParentId) {
        Utils.checkNotNull(remoteParentId, "remoteParentId");
        this.remoteParentId = JsonNullable.of(remoteParentId);
        return this;
    }

    /**
     * Provider's unique identifier of the parent group id for when a group belongs to another group.
     */
    public IamGroup withRemoteParentId(JsonNullable<String> remoteParentId) {
        Utils.checkNotNull(remoteParentId, "remoteParentId");
        this.remoteParentId = remoteParentId;
        return this;
    }

    public IamGroup withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    public IamGroup withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public IamGroup withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    public IamGroup withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IamGroup other = (IamGroup) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.description, other.description) &&
            Utils.enhancedDeepEquals(this.type, other.type) &&
            Utils.enhancedDeepEquals(this.roles, other.roles) &&
            Utils.enhancedDeepEquals(this.parentId, other.parentId) &&
            Utils.enhancedDeepEquals(this.remoteParentId, other.remoteParentId) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt) &&
            Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, name,
            description, type, roles,
            parentId, remoteParentId, createdAt,
            updatedAt);
    }
    
    @Override
    public String toString() {
        return Utils.toString(IamGroup.class,
                "id", id,
                "remoteId", remoteId,
                "name", name,
                "description", description,
                "type", type,
                "roles", roles,
                "parentId", parentId,
                "remoteParentId", remoteParentId,
                "createdAt", createdAt,
                "updatedAt", updatedAt);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<String> name = JsonNullable.undefined();

        private JsonNullable<String> description = JsonNullable.undefined();

        private JsonNullable<? extends IamGroupType> type = JsonNullable.undefined();

        private JsonNullable<? extends List<IamRole>> roles = JsonNullable.undefined();

        private JsonNullable<String> parentId = JsonNullable.undefined();

        private JsonNullable<String> remoteParentId = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }


        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = JsonNullable.of(description);
            return this;
        }

        public Builder description(JsonNullable<String> description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }


        public Builder type(IamGroupType type) {
            Utils.checkNotNull(type, "type");
            this.type = JsonNullable.of(type);
            return this;
        }

        public Builder type(JsonNullable<? extends IamGroupType> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }


        public Builder roles(List<IamRole> roles) {
            Utils.checkNotNull(roles, "roles");
            this.roles = JsonNullable.of(roles);
            return this;
        }

        public Builder roles(JsonNullable<? extends List<IamRole>> roles) {
            Utils.checkNotNull(roles, "roles");
            this.roles = roles;
            return this;
        }


        /**
         * The parent group id for when a group belongs to another group.
         */
        public Builder parentId(String parentId) {
            Utils.checkNotNull(parentId, "parentId");
            this.parentId = JsonNullable.of(parentId);
            return this;
        }

        /**
         * The parent group id for when a group belongs to another group.
         */
        public Builder parentId(JsonNullable<String> parentId) {
            Utils.checkNotNull(parentId, "parentId");
            this.parentId = parentId;
            return this;
        }


        /**
         * Provider's unique identifier of the parent group id for when a group belongs to another group.
         */
        public Builder remoteParentId(String remoteParentId) {
            Utils.checkNotNull(remoteParentId, "remoteParentId");
            this.remoteParentId = JsonNullable.of(remoteParentId);
            return this;
        }

        /**
         * Provider's unique identifier of the parent group id for when a group belongs to another group.
         */
        public Builder remoteParentId(JsonNullable<String> remoteParentId) {
            Utils.checkNotNull(remoteParentId, "remoteParentId");
            this.remoteParentId = remoteParentId;
            return this;
        }


        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }


        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public IamGroup build() {

            return new IamGroup(
                id, remoteId, name,
                description, type, roles,
                parentId, remoteParentId, createdAt,
                updatedAt);
        }

    }
}
