/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * JobValue
 * 
 * <p>The status of the job.
 */
@JsonDeserialize(using = JobValue._Deserializer.class)
@JsonSerialize(using = JobValue._Serializer.class)
public class JobValue {

    public static final JobValue PUBLISHED = new JobValue("published");
    public static final JobValue DRAFT = new JobValue("draft");
    public static final JobValue PENDING = new JobValue("pending");
    public static final JobValue INTERNAL = new JobValue("internal");
    public static final JobValue ARCHIVED = new JobValue("archived");
    public static final JobValue CLOSED = new JobValue("closed");
    public static final JobValue OPEN = new JobValue("open");
    public static final JobValue DELETED = new JobValue("deleted");
    public static final JobValue ON_HOLD = new JobValue("on_hold");
    public static final JobValue UNMAPPED_VALUE = new JobValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, JobValue> values = createValuesMap();
    private static final Map<String, JobValueEnum> enums = createEnumsMap();

    private final String value;

    private JobValue(String value) {
        this.value = value;
    }

    /**
     * Returns a JobValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as JobValue
     */ 
    public static JobValue of(String value) {
        synchronized (JobValue.class) {
            return values.computeIfAbsent(value, v -> new JobValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<JobValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        JobValue other = (JobValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "JobValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static JobValue[] values() {
        synchronized (JobValue.class) {
            return values.values().toArray(new JobValue[] {});
        }
    }

    private static final Map<String, JobValue> createValuesMap() {
        Map<String, JobValue> map = new LinkedHashMap<>();
        map.put("published", PUBLISHED);
        map.put("draft", DRAFT);
        map.put("pending", PENDING);
        map.put("internal", INTERNAL);
        map.put("archived", ARCHIVED);
        map.put("closed", CLOSED);
        map.put("open", OPEN);
        map.put("deleted", DELETED);
        map.put("on_hold", ON_HOLD);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, JobValueEnum> createEnumsMap() {
        Map<String, JobValueEnum> map = new HashMap<>();
        map.put("published", JobValueEnum.PUBLISHED);
        map.put("draft", JobValueEnum.DRAFT);
        map.put("pending", JobValueEnum.PENDING);
        map.put("internal", JobValueEnum.INTERNAL);
        map.put("archived", JobValueEnum.ARCHIVED);
        map.put("closed", JobValueEnum.CLOSED);
        map.put("open", JobValueEnum.OPEN);
        map.put("deleted", JobValueEnum.DELETED);
        map.put("on_hold", JobValueEnum.ON_HOLD);
        map.put("unmapped_value", JobValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<JobValue> {

        protected _Serializer() {
            super(JobValue.class);
        }

        @Override
        public void serialize(JobValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<JobValue> {

        protected _Deserializer() {
            super(JobValue.class);
        }

        @Override
        public JobValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return JobValue.of(v);
        }
    }
    
    public enum JobValueEnum {

        PUBLISHED("published"),
        DRAFT("draft"),
        PENDING("pending"),
        INTERNAL("internal"),
        ARCHIVED("archived"),
        CLOSED("closed"),
        OPEN("open"),
        DELETED("deleted"),
        ON_HOLD("on_hold"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private JobValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

