/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * LocationType
 * 
 * <p>The location type
 */
public class LocationType {
    /**
     * The type of the location.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends HRISLocationLocationTypeValue> value;

    /**
     * The source value of the location type.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends HRISLocationLocationTypeSourceValue> sourceValue;

    @JsonCreator
    public LocationType(
            @JsonProperty("value") JsonNullable<? extends HRISLocationLocationTypeValue> value,
            @JsonProperty("source_value") JsonNullable<? extends HRISLocationLocationTypeSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public LocationType() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The type of the location.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HRISLocationLocationTypeValue> value() {
        return (JsonNullable<HRISLocationLocationTypeValue>) value;
    }

    /**
     * The source value of the location type.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HRISLocationLocationTypeSourceValue> sourceValue() {
        return (JsonNullable<HRISLocationLocationTypeSourceValue>) sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The type of the location.
     */
    public LocationType withValue(HRISLocationLocationTypeValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The type of the location.
     */
    public LocationType withValue(JsonNullable<? extends HRISLocationLocationTypeValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The source value of the location type.
     */
    public LocationType withSourceValue(HRISLocationLocationTypeSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The source value of the location type.
     */
    public LocationType withSourceValue(JsonNullable<? extends HRISLocationLocationTypeSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LocationType other = (LocationType) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value, sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(LocationType.class,
                "value", value,
                "sourceValue", sourceValue);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends HRISLocationLocationTypeValue> value = JsonNullable.undefined();

        private JsonNullable<? extends HRISLocationLocationTypeSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The type of the location.
         */
        public Builder value(HRISLocationLocationTypeValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The type of the location.
         */
        public Builder value(JsonNullable<? extends HRISLocationLocationTypeValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }


        /**
         * The source value of the location type.
         */
        public Builder sourceValue(HRISLocationLocationTypeSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The source value of the location type.
         */
        public Builder sourceValue(JsonNullable<? extends HRISLocationLocationTypeSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public LocationType build() {

            return new LocationType(
                value, sourceValue);
        }

    }
}
