/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;


public class MessagingUser {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * Email address of the user
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("email")
    private JsonNullable<String> email;

    /**
     * Username of the user
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("username")
    private JsonNullable<String> username;

    /**
     * Full name of the user
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    /**
     * First name of the user
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("first_name")
    private JsonNullable<String> firstName;

    /**
     * Last name of the user
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("last_name")
    private JsonNullable<String> lastName;

    /**
     * Whether the user is a bot
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("bot")
    private JsonNullable<? extends Bot> bot;

    /**
     * Whether the user is active
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("active")
    private JsonNullable<? extends MessagingUserActive> active;

    @JsonCreator
    public MessagingUser(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("email") JsonNullable<String> email,
            @JsonProperty("username") JsonNullable<String> username,
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("first_name") JsonNullable<String> firstName,
            @JsonProperty("last_name") JsonNullable<String> lastName,
            @JsonProperty("bot") JsonNullable<? extends Bot> bot,
            @JsonProperty("active") JsonNullable<? extends MessagingUserActive> active) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(email, "email");
        Utils.checkNotNull(username, "username");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(firstName, "firstName");
        Utils.checkNotNull(lastName, "lastName");
        Utils.checkNotNull(bot, "bot");
        Utils.checkNotNull(active, "active");
        this.id = id;
        this.remoteId = remoteId;
        this.email = email;
        this.username = username;
        this.name = name;
        this.firstName = firstName;
        this.lastName = lastName;
        this.bot = bot;
        this.active = active;
    }
    
    public MessagingUser() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * Email address of the user
     */
    @JsonIgnore
    public JsonNullable<String> email() {
        return email;
    }

    /**
     * Username of the user
     */
    @JsonIgnore
    public JsonNullable<String> username() {
        return username;
    }

    /**
     * Full name of the user
     */
    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    /**
     * First name of the user
     */
    @JsonIgnore
    public JsonNullable<String> firstName() {
        return firstName;
    }

    /**
     * Last name of the user
     */
    @JsonIgnore
    public JsonNullable<String> lastName() {
        return lastName;
    }

    /**
     * Whether the user is a bot
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Bot> bot() {
        return (JsonNullable<Bot>) bot;
    }

    /**
     * Whether the user is active
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<MessagingUserActive> active() {
        return (JsonNullable<MessagingUserActive>) active;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public MessagingUser withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public MessagingUser withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public MessagingUser withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public MessagingUser withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * Email address of the user
     */
    public MessagingUser withEmail(String email) {
        Utils.checkNotNull(email, "email");
        this.email = JsonNullable.of(email);
        return this;
    }

    /**
     * Email address of the user
     */
    public MessagingUser withEmail(JsonNullable<String> email) {
        Utils.checkNotNull(email, "email");
        this.email = email;
        return this;
    }

    /**
     * Username of the user
     */
    public MessagingUser withUsername(String username) {
        Utils.checkNotNull(username, "username");
        this.username = JsonNullable.of(username);
        return this;
    }

    /**
     * Username of the user
     */
    public MessagingUser withUsername(JsonNullable<String> username) {
        Utils.checkNotNull(username, "username");
        this.username = username;
        return this;
    }

    /**
     * Full name of the user
     */
    public MessagingUser withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    /**
     * Full name of the user
     */
    public MessagingUser withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * First name of the user
     */
    public MessagingUser withFirstName(String firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = JsonNullable.of(firstName);
        return this;
    }

    /**
     * First name of the user
     */
    public MessagingUser withFirstName(JsonNullable<String> firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = firstName;
        return this;
    }

    /**
     * Last name of the user
     */
    public MessagingUser withLastName(String lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = JsonNullable.of(lastName);
        return this;
    }

    /**
     * Last name of the user
     */
    public MessagingUser withLastName(JsonNullable<String> lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = lastName;
        return this;
    }

    /**
     * Whether the user is a bot
     */
    public MessagingUser withBot(Bot bot) {
        Utils.checkNotNull(bot, "bot");
        this.bot = JsonNullable.of(bot);
        return this;
    }

    /**
     * Whether the user is a bot
     */
    public MessagingUser withBot(JsonNullable<? extends Bot> bot) {
        Utils.checkNotNull(bot, "bot");
        this.bot = bot;
        return this;
    }

    /**
     * Whether the user is active
     */
    public MessagingUser withActive(MessagingUserActive active) {
        Utils.checkNotNull(active, "active");
        this.active = JsonNullable.of(active);
        return this;
    }

    /**
     * Whether the user is active
     */
    public MessagingUser withActive(JsonNullable<? extends MessagingUserActive> active) {
        Utils.checkNotNull(active, "active");
        this.active = active;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MessagingUser other = (MessagingUser) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.email, other.email) &&
            Utils.enhancedDeepEquals(this.username, other.username) &&
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.firstName, other.firstName) &&
            Utils.enhancedDeepEquals(this.lastName, other.lastName) &&
            Utils.enhancedDeepEquals(this.bot, other.bot) &&
            Utils.enhancedDeepEquals(this.active, other.active);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, email,
            username, name, firstName,
            lastName, bot, active);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MessagingUser.class,
                "id", id,
                "remoteId", remoteId,
                "email", email,
                "username", username,
                "name", name,
                "firstName", firstName,
                "lastName", lastName,
                "bot", bot,
                "active", active);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<String> email = JsonNullable.undefined();

        private JsonNullable<String> username = JsonNullable.undefined();

        private JsonNullable<String> name = JsonNullable.undefined();

        private JsonNullable<String> firstName = JsonNullable.undefined();

        private JsonNullable<String> lastName = JsonNullable.undefined();

        private JsonNullable<? extends Bot> bot = JsonNullable.undefined();

        private JsonNullable<? extends MessagingUserActive> active = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * Email address of the user
         */
        public Builder email(String email) {
            Utils.checkNotNull(email, "email");
            this.email = JsonNullable.of(email);
            return this;
        }

        /**
         * Email address of the user
         */
        public Builder email(JsonNullable<String> email) {
            Utils.checkNotNull(email, "email");
            this.email = email;
            return this;
        }


        /**
         * Username of the user
         */
        public Builder username(String username) {
            Utils.checkNotNull(username, "username");
            this.username = JsonNullable.of(username);
            return this;
        }

        /**
         * Username of the user
         */
        public Builder username(JsonNullable<String> username) {
            Utils.checkNotNull(username, "username");
            this.username = username;
            return this;
        }


        /**
         * Full name of the user
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        /**
         * Full name of the user
         */
        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }


        /**
         * First name of the user
         */
        public Builder firstName(String firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = JsonNullable.of(firstName);
            return this;
        }

        /**
         * First name of the user
         */
        public Builder firstName(JsonNullable<String> firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = firstName;
            return this;
        }


        /**
         * Last name of the user
         */
        public Builder lastName(String lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = JsonNullable.of(lastName);
            return this;
        }

        /**
         * Last name of the user
         */
        public Builder lastName(JsonNullable<String> lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = lastName;
            return this;
        }


        /**
         * Whether the user is a bot
         */
        public Builder bot(Bot bot) {
            Utils.checkNotNull(bot, "bot");
            this.bot = JsonNullable.of(bot);
            return this;
        }

        /**
         * Whether the user is a bot
         */
        public Builder bot(JsonNullable<? extends Bot> bot) {
            Utils.checkNotNull(bot, "bot");
            this.bot = bot;
            return this;
        }


        /**
         * Whether the user is active
         */
        public Builder active(MessagingUserActive active) {
            Utils.checkNotNull(active, "active");
            this.active = JsonNullable.of(active);
            return this;
        }

        /**
         * Whether the user is active
         */
        public Builder active(JsonNullable<? extends MessagingUserActive> active) {
            Utils.checkNotNull(active, "active");
            this.active = active;
            return this;
        }

        public MessagingUser build() {

            return new MessagingUser(
                id, remoteId, email,
                username, name, firstName,
                lastName, bot, active);
        }

    }
}
