/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;


public class ScreeningResult {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("unified_custom_fields")
    private JsonNullable<? extends Map<String, Object>> unifiedCustomFields;

    /**
     * Order ID associated with this result
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("order_id")
    private JsonNullable<String> orderId;

    /**
     * Score information
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("score")
    private JsonNullable<? extends ScreeningResultScore> score;

    /**
     * Start date of the screening
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("start_date")
    private JsonNullable<OffsetDateTime> startDate;

    /**
     * Submission date of the screening
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("submission_date")
    private JsonNullable<OffsetDateTime> submissionDate;

    /**
     * Summary of the screening result
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("summary")
    private JsonNullable<String> summary;

    /**
     * Result status
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("status")
    private JsonNullable<? extends ScreeningResultStatus> status;

    /**
     * URL to view the detailed result
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("result_url")
    private JsonNullable<String> resultUrl;

    @JsonCreator
    public ScreeningResult(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("unified_custom_fields") JsonNullable<? extends Map<String, Object>> unifiedCustomFields,
            @JsonProperty("order_id") JsonNullable<String> orderId,
            @JsonProperty("score") JsonNullable<? extends ScreeningResultScore> score,
            @JsonProperty("start_date") JsonNullable<OffsetDateTime> startDate,
            @JsonProperty("submission_date") JsonNullable<OffsetDateTime> submissionDate,
            @JsonProperty("summary") JsonNullable<String> summary,
            @JsonProperty("status") JsonNullable<? extends ScreeningResultStatus> status,
            @JsonProperty("result_url") JsonNullable<String> resultUrl) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        Utils.checkNotNull(orderId, "orderId");
        Utils.checkNotNull(score, "score");
        Utils.checkNotNull(startDate, "startDate");
        Utils.checkNotNull(submissionDate, "submissionDate");
        Utils.checkNotNull(summary, "summary");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(resultUrl, "resultUrl");
        this.id = id;
        this.remoteId = remoteId;
        this.unifiedCustomFields = unifiedCustomFields;
        this.orderId = orderId;
        this.score = score;
        this.startDate = startDate;
        this.submissionDate = submissionDate;
        this.summary = summary;
        this.status = status;
        this.resultUrl = resultUrl;
    }
    
    public ScreeningResult() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> unifiedCustomFields() {
        return (JsonNullable<Map<String, Object>>) unifiedCustomFields;
    }

    /**
     * Order ID associated with this result
     */
    @JsonIgnore
    public JsonNullable<String> orderId() {
        return orderId;
    }

    /**
     * Score information
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ScreeningResultScore> score() {
        return (JsonNullable<ScreeningResultScore>) score;
    }

    /**
     * Start date of the screening
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> startDate() {
        return startDate;
    }

    /**
     * Submission date of the screening
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> submissionDate() {
        return submissionDate;
    }

    /**
     * Summary of the screening result
     */
    @JsonIgnore
    public JsonNullable<String> summary() {
        return summary;
    }

    /**
     * Result status
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ScreeningResultStatus> status() {
        return (JsonNullable<ScreeningResultStatus>) status;
    }

    /**
     * URL to view the detailed result
     */
    @JsonIgnore
    public JsonNullable<String> resultUrl() {
        return resultUrl;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public ScreeningResult withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public ScreeningResult withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public ScreeningResult withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public ScreeningResult withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public ScreeningResult withUnifiedCustomFields(Map<String, Object> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public ScreeningResult withUnifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = unifiedCustomFields;
        return this;
    }

    /**
     * Order ID associated with this result
     */
    public ScreeningResult withOrderId(String orderId) {
        Utils.checkNotNull(orderId, "orderId");
        this.orderId = JsonNullable.of(orderId);
        return this;
    }

    /**
     * Order ID associated with this result
     */
    public ScreeningResult withOrderId(JsonNullable<String> orderId) {
        Utils.checkNotNull(orderId, "orderId");
        this.orderId = orderId;
        return this;
    }

    /**
     * Score information
     */
    public ScreeningResult withScore(ScreeningResultScore score) {
        Utils.checkNotNull(score, "score");
        this.score = JsonNullable.of(score);
        return this;
    }

    /**
     * Score information
     */
    public ScreeningResult withScore(JsonNullable<? extends ScreeningResultScore> score) {
        Utils.checkNotNull(score, "score");
        this.score = score;
        return this;
    }

    /**
     * Start date of the screening
     */
    public ScreeningResult withStartDate(OffsetDateTime startDate) {
        Utils.checkNotNull(startDate, "startDate");
        this.startDate = JsonNullable.of(startDate);
        return this;
    }

    /**
     * Start date of the screening
     */
    public ScreeningResult withStartDate(JsonNullable<OffsetDateTime> startDate) {
        Utils.checkNotNull(startDate, "startDate");
        this.startDate = startDate;
        return this;
    }

    /**
     * Submission date of the screening
     */
    public ScreeningResult withSubmissionDate(OffsetDateTime submissionDate) {
        Utils.checkNotNull(submissionDate, "submissionDate");
        this.submissionDate = JsonNullable.of(submissionDate);
        return this;
    }

    /**
     * Submission date of the screening
     */
    public ScreeningResult withSubmissionDate(JsonNullable<OffsetDateTime> submissionDate) {
        Utils.checkNotNull(submissionDate, "submissionDate");
        this.submissionDate = submissionDate;
        return this;
    }

    /**
     * Summary of the screening result
     */
    public ScreeningResult withSummary(String summary) {
        Utils.checkNotNull(summary, "summary");
        this.summary = JsonNullable.of(summary);
        return this;
    }

    /**
     * Summary of the screening result
     */
    public ScreeningResult withSummary(JsonNullable<String> summary) {
        Utils.checkNotNull(summary, "summary");
        this.summary = summary;
        return this;
    }

    /**
     * Result status
     */
    public ScreeningResult withStatus(ScreeningResultStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = JsonNullable.of(status);
        return this;
    }

    /**
     * Result status
     */
    public ScreeningResult withStatus(JsonNullable<? extends ScreeningResultStatus> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * URL to view the detailed result
     */
    public ScreeningResult withResultUrl(String resultUrl) {
        Utils.checkNotNull(resultUrl, "resultUrl");
        this.resultUrl = JsonNullable.of(resultUrl);
        return this;
    }

    /**
     * URL to view the detailed result
     */
    public ScreeningResult withResultUrl(JsonNullable<String> resultUrl) {
        Utils.checkNotNull(resultUrl, "resultUrl");
        this.resultUrl = resultUrl;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ScreeningResult other = (ScreeningResult) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.unifiedCustomFields, other.unifiedCustomFields) &&
            Utils.enhancedDeepEquals(this.orderId, other.orderId) &&
            Utils.enhancedDeepEquals(this.score, other.score) &&
            Utils.enhancedDeepEquals(this.startDate, other.startDate) &&
            Utils.enhancedDeepEquals(this.submissionDate, other.submissionDate) &&
            Utils.enhancedDeepEquals(this.summary, other.summary) &&
            Utils.enhancedDeepEquals(this.status, other.status) &&
            Utils.enhancedDeepEquals(this.resultUrl, other.resultUrl);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, unifiedCustomFields,
            orderId, score, startDate,
            submissionDate, summary, status,
            resultUrl);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ScreeningResult.class,
                "id", id,
                "remoteId", remoteId,
                "unifiedCustomFields", unifiedCustomFields,
                "orderId", orderId,
                "score", score,
                "startDate", startDate,
                "submissionDate", submissionDate,
                "summary", summary,
                "status", status,
                "resultUrl", resultUrl);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<? extends Map<String, Object>> unifiedCustomFields = JsonNullable.undefined();

        private JsonNullable<String> orderId = JsonNullable.undefined();

        private JsonNullable<? extends ScreeningResultScore> score = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> startDate = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> submissionDate = JsonNullable.undefined();

        private JsonNullable<String> summary = JsonNullable.undefined();

        private JsonNullable<? extends ScreeningResultStatus> status = JsonNullable.undefined();

        private JsonNullable<String> resultUrl = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(Map<String, Object> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = unifiedCustomFields;
            return this;
        }


        /**
         * Order ID associated with this result
         */
        public Builder orderId(String orderId) {
            Utils.checkNotNull(orderId, "orderId");
            this.orderId = JsonNullable.of(orderId);
            return this;
        }

        /**
         * Order ID associated with this result
         */
        public Builder orderId(JsonNullable<String> orderId) {
            Utils.checkNotNull(orderId, "orderId");
            this.orderId = orderId;
            return this;
        }


        /**
         * Score information
         */
        public Builder score(ScreeningResultScore score) {
            Utils.checkNotNull(score, "score");
            this.score = JsonNullable.of(score);
            return this;
        }

        /**
         * Score information
         */
        public Builder score(JsonNullable<? extends ScreeningResultScore> score) {
            Utils.checkNotNull(score, "score");
            this.score = score;
            return this;
        }


        /**
         * Start date of the screening
         */
        public Builder startDate(OffsetDateTime startDate) {
            Utils.checkNotNull(startDate, "startDate");
            this.startDate = JsonNullable.of(startDate);
            return this;
        }

        /**
         * Start date of the screening
         */
        public Builder startDate(JsonNullable<OffsetDateTime> startDate) {
            Utils.checkNotNull(startDate, "startDate");
            this.startDate = startDate;
            return this;
        }


        /**
         * Submission date of the screening
         */
        public Builder submissionDate(OffsetDateTime submissionDate) {
            Utils.checkNotNull(submissionDate, "submissionDate");
            this.submissionDate = JsonNullable.of(submissionDate);
            return this;
        }

        /**
         * Submission date of the screening
         */
        public Builder submissionDate(JsonNullable<OffsetDateTime> submissionDate) {
            Utils.checkNotNull(submissionDate, "submissionDate");
            this.submissionDate = submissionDate;
            return this;
        }


        /**
         * Summary of the screening result
         */
        public Builder summary(String summary) {
            Utils.checkNotNull(summary, "summary");
            this.summary = JsonNullable.of(summary);
            return this;
        }

        /**
         * Summary of the screening result
         */
        public Builder summary(JsonNullable<String> summary) {
            Utils.checkNotNull(summary, "summary");
            this.summary = summary;
            return this;
        }


        /**
         * Result status
         */
        public Builder status(ScreeningResultStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = JsonNullable.of(status);
            return this;
        }

        /**
         * Result status
         */
        public Builder status(JsonNullable<? extends ScreeningResultStatus> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }


        /**
         * URL to view the detailed result
         */
        public Builder resultUrl(String resultUrl) {
            Utils.checkNotNull(resultUrl, "resultUrl");
            this.resultUrl = JsonNullable.of(resultUrl);
            return this;
        }

        /**
         * URL to view the detailed result
         */
        public Builder resultUrl(JsonNullable<String> resultUrl) {
            Utils.checkNotNull(resultUrl, "resultUrl");
            this.resultUrl = resultUrl;
            return this;
        }

        public ScreeningResult build() {

            return new ScreeningResult(
                id, remoteId, unifiedCustomFields,
                orderId, score, startDate,
                submissionDate, summary, status,
                resultUrl);
        }

    }
}
