/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * TaskValue
 * 
 * <p>The unified value for the type of the task. If the provider does not specify this type, the value will be set to UnmappedValue
 */
@JsonDeserialize(using = TaskValue._Deserializer.class)
@JsonSerialize(using = TaskValue._Serializer.class)
public class TaskValue {

    public static final TaskValue ACTION = new TaskValue("action");
    public static final TaskValue REVIEW = new TaskValue("review");
    public static final TaskValue ACKNOWLEDGMENT = new TaskValue("acknowledgment");
    public static final TaskValue EDIT = new TaskValue("edit");
    public static final TaskValue APPROVE = new TaskValue("approve");
    public static final TaskValue UNMAPPED_VALUE = new TaskValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, TaskValue> values = createValuesMap();
    private static final Map<String, TaskValueEnum> enums = createEnumsMap();

    private final String value;

    private TaskValue(String value) {
        this.value = value;
    }

    /**
     * Returns a TaskValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as TaskValue
     */ 
    public static TaskValue of(String value) {
        synchronized (TaskValue.class) {
            return values.computeIfAbsent(value, v -> new TaskValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<TaskValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        TaskValue other = (TaskValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "TaskValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static TaskValue[] values() {
        synchronized (TaskValue.class) {
            return values.values().toArray(new TaskValue[] {});
        }
    }

    private static final Map<String, TaskValue> createValuesMap() {
        Map<String, TaskValue> map = new LinkedHashMap<>();
        map.put("action", ACTION);
        map.put("review", REVIEW);
        map.put("acknowledgment", ACKNOWLEDGMENT);
        map.put("edit", EDIT);
        map.put("approve", APPROVE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TaskValueEnum> createEnumsMap() {
        Map<String, TaskValueEnum> map = new HashMap<>();
        map.put("action", TaskValueEnum.ACTION);
        map.put("review", TaskValueEnum.REVIEW);
        map.put("acknowledgment", TaskValueEnum.ACKNOWLEDGMENT);
        map.put("edit", TaskValueEnum.EDIT);
        map.put("approve", TaskValueEnum.APPROVE);
        map.put("unmapped_value", TaskValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<TaskValue> {

        protected _Serializer() {
            super(TaskValue.class);
        }

        @Override
        public void serialize(TaskValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<TaskValue> {

        protected _Deserializer() {
            super(TaskValue.class);
        }

        @Override
        public TaskValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return TaskValue.of(v);
        }
    }
    
    public enum TaskValueEnum {

        ACTION("action"),
        REVIEW("review"),
        ACKNOWLEDGMENT("acknowledgment"),
        EDIT("edit"),
        APPROVE("approve"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private TaskValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

