/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;


public class TicketingComment {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * The ticket ID associated with the comment
     */
    @JsonProperty("ticket_id")
    private String ticketId;

    /**
     * The user who created the comment
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("user_id")
    private JsonNullable<String> userId;

    /**
     * Whether the comment is internal
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("internal")
    private JsonNullable<? extends TicketingCommentInternal> internal;

    /**
     * Array of content associated with the comment
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("content")
    private JsonNullable<? extends List<TicketingContent>> content;

    /**
     * The timestamp when the record was created
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * The timestamp when the record was last updated
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    @JsonCreator
    public TicketingComment(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("ticket_id") String ticketId,
            @JsonProperty("user_id") JsonNullable<String> userId,
            @JsonProperty("internal") JsonNullable<? extends TicketingCommentInternal> internal,
            @JsonProperty("content") JsonNullable<? extends List<TicketingContent>> content,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(ticketId, "ticketId");
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(internal, "internal");
        Utils.checkNotNull(content, "content");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.id = id;
        this.remoteId = remoteId;
        this.ticketId = ticketId;
        this.userId = userId;
        this.internal = internal;
        this.content = content;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }
    
    public TicketingComment(
            String ticketId) {
        this(JsonNullable.undefined(), JsonNullable.undefined(), ticketId,
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * The ticket ID associated with the comment
     */
    @JsonIgnore
    public String ticketId() {
        return ticketId;
    }

    /**
     * The user who created the comment
     */
    @JsonIgnore
    public JsonNullable<String> userId() {
        return userId;
    }

    /**
     * Whether the comment is internal
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TicketingCommentInternal> internal() {
        return (JsonNullable<TicketingCommentInternal>) internal;
    }

    /**
     * Array of content associated with the comment
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<TicketingContent>> content() {
        return (JsonNullable<List<TicketingContent>>) content;
    }

    /**
     * The timestamp when the record was created
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * The timestamp when the record was last updated
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public TicketingComment withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public TicketingComment withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public TicketingComment withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public TicketingComment withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * The ticket ID associated with the comment
     */
    public TicketingComment withTicketId(String ticketId) {
        Utils.checkNotNull(ticketId, "ticketId");
        this.ticketId = ticketId;
        return this;
    }

    /**
     * The user who created the comment
     */
    public TicketingComment withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = JsonNullable.of(userId);
        return this;
    }

    /**
     * The user who created the comment
     */
    public TicketingComment withUserId(JsonNullable<String> userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    /**
     * Whether the comment is internal
     */
    public TicketingComment withInternal(TicketingCommentInternal internal) {
        Utils.checkNotNull(internal, "internal");
        this.internal = JsonNullable.of(internal);
        return this;
    }

    /**
     * Whether the comment is internal
     */
    public TicketingComment withInternal(JsonNullable<? extends TicketingCommentInternal> internal) {
        Utils.checkNotNull(internal, "internal");
        this.internal = internal;
        return this;
    }

    /**
     * Array of content associated with the comment
     */
    public TicketingComment withContent(List<TicketingContent> content) {
        Utils.checkNotNull(content, "content");
        this.content = JsonNullable.of(content);
        return this;
    }

    /**
     * Array of content associated with the comment
     */
    public TicketingComment withContent(JsonNullable<? extends List<TicketingContent>> content) {
        Utils.checkNotNull(content, "content");
        this.content = content;
        return this;
    }

    /**
     * The timestamp when the record was created
     */
    public TicketingComment withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * The timestamp when the record was created
     */
    public TicketingComment withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * The timestamp when the record was last updated
     */
    public TicketingComment withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * The timestamp when the record was last updated
     */
    public TicketingComment withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TicketingComment other = (TicketingComment) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.ticketId, other.ticketId) &&
            Utils.enhancedDeepEquals(this.userId, other.userId) &&
            Utils.enhancedDeepEquals(this.internal, other.internal) &&
            Utils.enhancedDeepEquals(this.content, other.content) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt) &&
            Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, ticketId,
            userId, internal, content,
            createdAt, updatedAt);
    }
    
    @Override
    public String toString() {
        return Utils.toString(TicketingComment.class,
                "id", id,
                "remoteId", remoteId,
                "ticketId", ticketId,
                "userId", userId,
                "internal", internal,
                "content", content,
                "createdAt", createdAt,
                "updatedAt", updatedAt);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private String ticketId;

        private JsonNullable<String> userId = JsonNullable.undefined();

        private JsonNullable<? extends TicketingCommentInternal> internal = JsonNullable.undefined();

        private JsonNullable<? extends List<TicketingContent>> content = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * The ticket ID associated with the comment
         */
        public Builder ticketId(String ticketId) {
            Utils.checkNotNull(ticketId, "ticketId");
            this.ticketId = ticketId;
            return this;
        }


        /**
         * The user who created the comment
         */
        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = JsonNullable.of(userId);
            return this;
        }

        /**
         * The user who created the comment
         */
        public Builder userId(JsonNullable<String> userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }


        /**
         * Whether the comment is internal
         */
        public Builder internal(TicketingCommentInternal internal) {
            Utils.checkNotNull(internal, "internal");
            this.internal = JsonNullable.of(internal);
            return this;
        }

        /**
         * Whether the comment is internal
         */
        public Builder internal(JsonNullable<? extends TicketingCommentInternal> internal) {
            Utils.checkNotNull(internal, "internal");
            this.internal = internal;
            return this;
        }


        /**
         * Array of content associated with the comment
         */
        public Builder content(List<TicketingContent> content) {
            Utils.checkNotNull(content, "content");
            this.content = JsonNullable.of(content);
            return this;
        }

        /**
         * Array of content associated with the comment
         */
        public Builder content(JsonNullable<? extends List<TicketingContent>> content) {
            Utils.checkNotNull(content, "content");
            this.content = content;
            return this;
        }


        /**
         * The timestamp when the record was created
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * The timestamp when the record was created
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }


        /**
         * The timestamp when the record was last updated
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * The timestamp when the record was last updated
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public TicketingComment build() {

            return new TicketingComment(
                id, remoteId, ticketId,
                userId, internal, content,
                createdAt, updatedAt);
        }

    }
}
