/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;


public class TicketingReadTicket {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("unified_custom_fields")
    private JsonNullable<? extends Map<String, Object>> unifiedCustomFields;

    /**
     * The title or subject of the ticket
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("title")
    private JsonNullable<String> title;

    /**
     * The creator of the ticket
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("creator_id")
    private JsonNullable<String> creatorId;

    /**
     * Users who reported the ticket
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("reporters")
    private JsonNullable<? extends List<String>> reporters;

    /**
     * Agents assigned to the ticket
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("assignees")
    private JsonNullable<? extends List<String>> assignees;

    /**
     * Array of content associated with the ticket
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("content")
    private JsonNullable<? extends List<TicketingContent>> content;

    /**
     * ID of the parent ticket if this is a sub-ticket
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("parent_id")
    private JsonNullable<String> parentId;

    /**
     * Priority of the ticket
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("priority")
    private JsonNullable<? extends Priority> priority;

    /**
     * The tags of the ticket
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("tags")
    private JsonNullable<? extends List<String>> tags;

    /**
     * Projects the ticket belongs to
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("projects")
    private JsonNullable<? extends List<TicketingProject>> projects;

    /**
     * The unique ticket number or reference ID
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("ticket_number")
    private JsonNullable<String> ticketNumber;

    /**
     * The type of the ticket
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("type")
    private JsonNullable<? extends TicketingReadTicketType> type;

    /**
     * The date the ticket was closed
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("closed_at")
    private JsonNullable<OffsetDateTime> closedAt;

    /**
     * URL to view the ticket in the source system
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("ticket_url")
    private JsonNullable<String> ticketUrl;

    /**
     * Current status of the ticket
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("status")
    private JsonNullable<? extends TicketingReadTicketStatus> status;

    /**
     * Organization associated with the ticket
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("organization")
    private JsonNullable<? extends Organization> organization;

    /**
     * Components associated with the ticket
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("components")
    private JsonNullable<? extends List<TicketingComponent>> components;

    /**
     * The timestamp when the record was created
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * The timestamp when the record was last updated
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    @JsonCreator
    public TicketingReadTicket(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("unified_custom_fields") JsonNullable<? extends Map<String, Object>> unifiedCustomFields,
            @JsonProperty("title") JsonNullable<String> title,
            @JsonProperty("creator_id") JsonNullable<String> creatorId,
            @JsonProperty("reporters") JsonNullable<? extends List<String>> reporters,
            @JsonProperty("assignees") JsonNullable<? extends List<String>> assignees,
            @JsonProperty("content") JsonNullable<? extends List<TicketingContent>> content,
            @JsonProperty("parent_id") JsonNullable<String> parentId,
            @JsonProperty("priority") JsonNullable<? extends Priority> priority,
            @JsonProperty("tags") JsonNullable<? extends List<String>> tags,
            @JsonProperty("projects") JsonNullable<? extends List<TicketingProject>> projects,
            @JsonProperty("ticket_number") JsonNullable<String> ticketNumber,
            @JsonProperty("type") JsonNullable<? extends TicketingReadTicketType> type,
            @JsonProperty("closed_at") JsonNullable<OffsetDateTime> closedAt,
            @JsonProperty("ticket_url") JsonNullable<String> ticketUrl,
            @JsonProperty("status") JsonNullable<? extends TicketingReadTicketStatus> status,
            @JsonProperty("organization") JsonNullable<? extends Organization> organization,
            @JsonProperty("components") JsonNullable<? extends List<TicketingComponent>> components,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        Utils.checkNotNull(title, "title");
        Utils.checkNotNull(creatorId, "creatorId");
        Utils.checkNotNull(reporters, "reporters");
        Utils.checkNotNull(assignees, "assignees");
        Utils.checkNotNull(content, "content");
        Utils.checkNotNull(parentId, "parentId");
        Utils.checkNotNull(priority, "priority");
        Utils.checkNotNull(tags, "tags");
        Utils.checkNotNull(projects, "projects");
        Utils.checkNotNull(ticketNumber, "ticketNumber");
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(closedAt, "closedAt");
        Utils.checkNotNull(ticketUrl, "ticketUrl");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(organization, "organization");
        Utils.checkNotNull(components, "components");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.id = id;
        this.remoteId = remoteId;
        this.unifiedCustomFields = unifiedCustomFields;
        this.title = title;
        this.creatorId = creatorId;
        this.reporters = reporters;
        this.assignees = assignees;
        this.content = content;
        this.parentId = parentId;
        this.priority = priority;
        this.tags = tags;
        this.projects = projects;
        this.ticketNumber = ticketNumber;
        this.type = type;
        this.closedAt = closedAt;
        this.ticketUrl = ticketUrl;
        this.status = status;
        this.organization = organization;
        this.components = components;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }
    
    public TicketingReadTicket() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> unifiedCustomFields() {
        return (JsonNullable<Map<String, Object>>) unifiedCustomFields;
    }

    /**
     * The title or subject of the ticket
     */
    @JsonIgnore
    public JsonNullable<String> title() {
        return title;
    }

    /**
     * The creator of the ticket
     */
    @JsonIgnore
    public JsonNullable<String> creatorId() {
        return creatorId;
    }

    /**
     * Users who reported the ticket
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> reporters() {
        return (JsonNullable<List<String>>) reporters;
    }

    /**
     * Agents assigned to the ticket
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> assignees() {
        return (JsonNullable<List<String>>) assignees;
    }

    /**
     * Array of content associated with the ticket
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<TicketingContent>> content() {
        return (JsonNullable<List<TicketingContent>>) content;
    }

    /**
     * ID of the parent ticket if this is a sub-ticket
     */
    @JsonIgnore
    public JsonNullable<String> parentId() {
        return parentId;
    }

    /**
     * Priority of the ticket
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Priority> priority() {
        return (JsonNullable<Priority>) priority;
    }

    /**
     * The tags of the ticket
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> tags() {
        return (JsonNullable<List<String>>) tags;
    }

    /**
     * Projects the ticket belongs to
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<TicketingProject>> projects() {
        return (JsonNullable<List<TicketingProject>>) projects;
    }

    /**
     * The unique ticket number or reference ID
     */
    @JsonIgnore
    public JsonNullable<String> ticketNumber() {
        return ticketNumber;
    }

    /**
     * The type of the ticket
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TicketingReadTicketType> type() {
        return (JsonNullable<TicketingReadTicketType>) type;
    }

    /**
     * The date the ticket was closed
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> closedAt() {
        return closedAt;
    }

    /**
     * URL to view the ticket in the source system
     */
    @JsonIgnore
    public JsonNullable<String> ticketUrl() {
        return ticketUrl;
    }

    /**
     * Current status of the ticket
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TicketingReadTicketStatus> status() {
        return (JsonNullable<TicketingReadTicketStatus>) status;
    }

    /**
     * Organization associated with the ticket
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Organization> organization() {
        return (JsonNullable<Organization>) organization;
    }

    /**
     * Components associated with the ticket
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<TicketingComponent>> components() {
        return (JsonNullable<List<TicketingComponent>>) components;
    }

    /**
     * The timestamp when the record was created
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * The timestamp when the record was last updated
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public TicketingReadTicket withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public TicketingReadTicket withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public TicketingReadTicket withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public TicketingReadTicket withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public TicketingReadTicket withUnifiedCustomFields(Map<String, Object> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public TicketingReadTicket withUnifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = unifiedCustomFields;
        return this;
    }

    /**
     * The title or subject of the ticket
     */
    public TicketingReadTicket withTitle(String title) {
        Utils.checkNotNull(title, "title");
        this.title = JsonNullable.of(title);
        return this;
    }

    /**
     * The title or subject of the ticket
     */
    public TicketingReadTicket withTitle(JsonNullable<String> title) {
        Utils.checkNotNull(title, "title");
        this.title = title;
        return this;
    }

    /**
     * The creator of the ticket
     */
    public TicketingReadTicket withCreatorId(String creatorId) {
        Utils.checkNotNull(creatorId, "creatorId");
        this.creatorId = JsonNullable.of(creatorId);
        return this;
    }

    /**
     * The creator of the ticket
     */
    public TicketingReadTicket withCreatorId(JsonNullable<String> creatorId) {
        Utils.checkNotNull(creatorId, "creatorId");
        this.creatorId = creatorId;
        return this;
    }

    /**
     * Users who reported the ticket
     */
    public TicketingReadTicket withReporters(List<String> reporters) {
        Utils.checkNotNull(reporters, "reporters");
        this.reporters = JsonNullable.of(reporters);
        return this;
    }

    /**
     * Users who reported the ticket
     */
    public TicketingReadTicket withReporters(JsonNullable<? extends List<String>> reporters) {
        Utils.checkNotNull(reporters, "reporters");
        this.reporters = reporters;
        return this;
    }

    /**
     * Agents assigned to the ticket
     */
    public TicketingReadTicket withAssignees(List<String> assignees) {
        Utils.checkNotNull(assignees, "assignees");
        this.assignees = JsonNullable.of(assignees);
        return this;
    }

    /**
     * Agents assigned to the ticket
     */
    public TicketingReadTicket withAssignees(JsonNullable<? extends List<String>> assignees) {
        Utils.checkNotNull(assignees, "assignees");
        this.assignees = assignees;
        return this;
    }

    /**
     * Array of content associated with the ticket
     */
    public TicketingReadTicket withContent(List<TicketingContent> content) {
        Utils.checkNotNull(content, "content");
        this.content = JsonNullable.of(content);
        return this;
    }

    /**
     * Array of content associated with the ticket
     */
    public TicketingReadTicket withContent(JsonNullable<? extends List<TicketingContent>> content) {
        Utils.checkNotNull(content, "content");
        this.content = content;
        return this;
    }

    /**
     * ID of the parent ticket if this is a sub-ticket
     */
    public TicketingReadTicket withParentId(String parentId) {
        Utils.checkNotNull(parentId, "parentId");
        this.parentId = JsonNullable.of(parentId);
        return this;
    }

    /**
     * ID of the parent ticket if this is a sub-ticket
     */
    public TicketingReadTicket withParentId(JsonNullable<String> parentId) {
        Utils.checkNotNull(parentId, "parentId");
        this.parentId = parentId;
        return this;
    }

    /**
     * Priority of the ticket
     */
    public TicketingReadTicket withPriority(Priority priority) {
        Utils.checkNotNull(priority, "priority");
        this.priority = JsonNullable.of(priority);
        return this;
    }

    /**
     * Priority of the ticket
     */
    public TicketingReadTicket withPriority(JsonNullable<? extends Priority> priority) {
        Utils.checkNotNull(priority, "priority");
        this.priority = priority;
        return this;
    }

    /**
     * The tags of the ticket
     */
    public TicketingReadTicket withTags(List<String> tags) {
        Utils.checkNotNull(tags, "tags");
        this.tags = JsonNullable.of(tags);
        return this;
    }

    /**
     * The tags of the ticket
     */
    public TicketingReadTicket withTags(JsonNullable<? extends List<String>> tags) {
        Utils.checkNotNull(tags, "tags");
        this.tags = tags;
        return this;
    }

    /**
     * Projects the ticket belongs to
     */
    public TicketingReadTicket withProjects(List<TicketingProject> projects) {
        Utils.checkNotNull(projects, "projects");
        this.projects = JsonNullable.of(projects);
        return this;
    }

    /**
     * Projects the ticket belongs to
     */
    public TicketingReadTicket withProjects(JsonNullable<? extends List<TicketingProject>> projects) {
        Utils.checkNotNull(projects, "projects");
        this.projects = projects;
        return this;
    }

    /**
     * The unique ticket number or reference ID
     */
    public TicketingReadTicket withTicketNumber(String ticketNumber) {
        Utils.checkNotNull(ticketNumber, "ticketNumber");
        this.ticketNumber = JsonNullable.of(ticketNumber);
        return this;
    }

    /**
     * The unique ticket number or reference ID
     */
    public TicketingReadTicket withTicketNumber(JsonNullable<String> ticketNumber) {
        Utils.checkNotNull(ticketNumber, "ticketNumber");
        this.ticketNumber = ticketNumber;
        return this;
    }

    /**
     * The type of the ticket
     */
    public TicketingReadTicket withType(TicketingReadTicketType type) {
        Utils.checkNotNull(type, "type");
        this.type = JsonNullable.of(type);
        return this;
    }

    /**
     * The type of the ticket
     */
    public TicketingReadTicket withType(JsonNullable<? extends TicketingReadTicketType> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    /**
     * The date the ticket was closed
     */
    public TicketingReadTicket withClosedAt(OffsetDateTime closedAt) {
        Utils.checkNotNull(closedAt, "closedAt");
        this.closedAt = JsonNullable.of(closedAt);
        return this;
    }

    /**
     * The date the ticket was closed
     */
    public TicketingReadTicket withClosedAt(JsonNullable<OffsetDateTime> closedAt) {
        Utils.checkNotNull(closedAt, "closedAt");
        this.closedAt = closedAt;
        return this;
    }

    /**
     * URL to view the ticket in the source system
     */
    public TicketingReadTicket withTicketUrl(String ticketUrl) {
        Utils.checkNotNull(ticketUrl, "ticketUrl");
        this.ticketUrl = JsonNullable.of(ticketUrl);
        return this;
    }

    /**
     * URL to view the ticket in the source system
     */
    public TicketingReadTicket withTicketUrl(JsonNullable<String> ticketUrl) {
        Utils.checkNotNull(ticketUrl, "ticketUrl");
        this.ticketUrl = ticketUrl;
        return this;
    }

    /**
     * Current status of the ticket
     */
    public TicketingReadTicket withStatus(TicketingReadTicketStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = JsonNullable.of(status);
        return this;
    }

    /**
     * Current status of the ticket
     */
    public TicketingReadTicket withStatus(JsonNullable<? extends TicketingReadTicketStatus> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * Organization associated with the ticket
     */
    public TicketingReadTicket withOrganization(Organization organization) {
        Utils.checkNotNull(organization, "organization");
        this.organization = JsonNullable.of(organization);
        return this;
    }

    /**
     * Organization associated with the ticket
     */
    public TicketingReadTicket withOrganization(JsonNullable<? extends Organization> organization) {
        Utils.checkNotNull(organization, "organization");
        this.organization = organization;
        return this;
    }

    /**
     * Components associated with the ticket
     */
    public TicketingReadTicket withComponents(List<TicketingComponent> components) {
        Utils.checkNotNull(components, "components");
        this.components = JsonNullable.of(components);
        return this;
    }

    /**
     * Components associated with the ticket
     */
    public TicketingReadTicket withComponents(JsonNullable<? extends List<TicketingComponent>> components) {
        Utils.checkNotNull(components, "components");
        this.components = components;
        return this;
    }

    /**
     * The timestamp when the record was created
     */
    public TicketingReadTicket withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * The timestamp when the record was created
     */
    public TicketingReadTicket withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * The timestamp when the record was last updated
     */
    public TicketingReadTicket withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * The timestamp when the record was last updated
     */
    public TicketingReadTicket withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TicketingReadTicket other = (TicketingReadTicket) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.unifiedCustomFields, other.unifiedCustomFields) &&
            Utils.enhancedDeepEquals(this.title, other.title) &&
            Utils.enhancedDeepEquals(this.creatorId, other.creatorId) &&
            Utils.enhancedDeepEquals(this.reporters, other.reporters) &&
            Utils.enhancedDeepEquals(this.assignees, other.assignees) &&
            Utils.enhancedDeepEquals(this.content, other.content) &&
            Utils.enhancedDeepEquals(this.parentId, other.parentId) &&
            Utils.enhancedDeepEquals(this.priority, other.priority) &&
            Utils.enhancedDeepEquals(this.tags, other.tags) &&
            Utils.enhancedDeepEquals(this.projects, other.projects) &&
            Utils.enhancedDeepEquals(this.ticketNumber, other.ticketNumber) &&
            Utils.enhancedDeepEquals(this.type, other.type) &&
            Utils.enhancedDeepEquals(this.closedAt, other.closedAt) &&
            Utils.enhancedDeepEquals(this.ticketUrl, other.ticketUrl) &&
            Utils.enhancedDeepEquals(this.status, other.status) &&
            Utils.enhancedDeepEquals(this.organization, other.organization) &&
            Utils.enhancedDeepEquals(this.components, other.components) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt) &&
            Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, unifiedCustomFields,
            title, creatorId, reporters,
            assignees, content, parentId,
            priority, tags, projects,
            ticketNumber, type, closedAt,
            ticketUrl, status, organization,
            components, createdAt, updatedAt);
    }
    
    @Override
    public String toString() {
        return Utils.toString(TicketingReadTicket.class,
                "id", id,
                "remoteId", remoteId,
                "unifiedCustomFields", unifiedCustomFields,
                "title", title,
                "creatorId", creatorId,
                "reporters", reporters,
                "assignees", assignees,
                "content", content,
                "parentId", parentId,
                "priority", priority,
                "tags", tags,
                "projects", projects,
                "ticketNumber", ticketNumber,
                "type", type,
                "closedAt", closedAt,
                "ticketUrl", ticketUrl,
                "status", status,
                "organization", organization,
                "components", components,
                "createdAt", createdAt,
                "updatedAt", updatedAt);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<? extends Map<String, Object>> unifiedCustomFields = JsonNullable.undefined();

        private JsonNullable<String> title = JsonNullable.undefined();

        private JsonNullable<String> creatorId = JsonNullable.undefined();

        private JsonNullable<? extends List<String>> reporters = JsonNullable.undefined();

        private JsonNullable<? extends List<String>> assignees = JsonNullable.undefined();

        private JsonNullable<? extends List<TicketingContent>> content = JsonNullable.undefined();

        private JsonNullable<String> parentId = JsonNullable.undefined();

        private JsonNullable<? extends Priority> priority = JsonNullable.undefined();

        private JsonNullable<? extends List<String>> tags = JsonNullable.undefined();

        private JsonNullable<? extends List<TicketingProject>> projects = JsonNullable.undefined();

        private JsonNullable<String> ticketNumber = JsonNullable.undefined();

        private JsonNullable<? extends TicketingReadTicketType> type = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> closedAt = JsonNullable.undefined();

        private JsonNullable<String> ticketUrl = JsonNullable.undefined();

        private JsonNullable<? extends TicketingReadTicketStatus> status = JsonNullable.undefined();

        private JsonNullable<? extends Organization> organization = JsonNullable.undefined();

        private JsonNullable<? extends List<TicketingComponent>> components = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(Map<String, Object> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = unifiedCustomFields;
            return this;
        }


        /**
         * The title or subject of the ticket
         */
        public Builder title(String title) {
            Utils.checkNotNull(title, "title");
            this.title = JsonNullable.of(title);
            return this;
        }

        /**
         * The title or subject of the ticket
         */
        public Builder title(JsonNullable<String> title) {
            Utils.checkNotNull(title, "title");
            this.title = title;
            return this;
        }


        /**
         * The creator of the ticket
         */
        public Builder creatorId(String creatorId) {
            Utils.checkNotNull(creatorId, "creatorId");
            this.creatorId = JsonNullable.of(creatorId);
            return this;
        }

        /**
         * The creator of the ticket
         */
        public Builder creatorId(JsonNullable<String> creatorId) {
            Utils.checkNotNull(creatorId, "creatorId");
            this.creatorId = creatorId;
            return this;
        }


        /**
         * Users who reported the ticket
         */
        public Builder reporters(List<String> reporters) {
            Utils.checkNotNull(reporters, "reporters");
            this.reporters = JsonNullable.of(reporters);
            return this;
        }

        /**
         * Users who reported the ticket
         */
        public Builder reporters(JsonNullable<? extends List<String>> reporters) {
            Utils.checkNotNull(reporters, "reporters");
            this.reporters = reporters;
            return this;
        }


        /**
         * Agents assigned to the ticket
         */
        public Builder assignees(List<String> assignees) {
            Utils.checkNotNull(assignees, "assignees");
            this.assignees = JsonNullable.of(assignees);
            return this;
        }

        /**
         * Agents assigned to the ticket
         */
        public Builder assignees(JsonNullable<? extends List<String>> assignees) {
            Utils.checkNotNull(assignees, "assignees");
            this.assignees = assignees;
            return this;
        }


        /**
         * Array of content associated with the ticket
         */
        public Builder content(List<TicketingContent> content) {
            Utils.checkNotNull(content, "content");
            this.content = JsonNullable.of(content);
            return this;
        }

        /**
         * Array of content associated with the ticket
         */
        public Builder content(JsonNullable<? extends List<TicketingContent>> content) {
            Utils.checkNotNull(content, "content");
            this.content = content;
            return this;
        }


        /**
         * ID of the parent ticket if this is a sub-ticket
         */
        public Builder parentId(String parentId) {
            Utils.checkNotNull(parentId, "parentId");
            this.parentId = JsonNullable.of(parentId);
            return this;
        }

        /**
         * ID of the parent ticket if this is a sub-ticket
         */
        public Builder parentId(JsonNullable<String> parentId) {
            Utils.checkNotNull(parentId, "parentId");
            this.parentId = parentId;
            return this;
        }


        /**
         * Priority of the ticket
         */
        public Builder priority(Priority priority) {
            Utils.checkNotNull(priority, "priority");
            this.priority = JsonNullable.of(priority);
            return this;
        }

        /**
         * Priority of the ticket
         */
        public Builder priority(JsonNullable<? extends Priority> priority) {
            Utils.checkNotNull(priority, "priority");
            this.priority = priority;
            return this;
        }


        /**
         * The tags of the ticket
         */
        public Builder tags(List<String> tags) {
            Utils.checkNotNull(tags, "tags");
            this.tags = JsonNullable.of(tags);
            return this;
        }

        /**
         * The tags of the ticket
         */
        public Builder tags(JsonNullable<? extends List<String>> tags) {
            Utils.checkNotNull(tags, "tags");
            this.tags = tags;
            return this;
        }


        /**
         * Projects the ticket belongs to
         */
        public Builder projects(List<TicketingProject> projects) {
            Utils.checkNotNull(projects, "projects");
            this.projects = JsonNullable.of(projects);
            return this;
        }

        /**
         * Projects the ticket belongs to
         */
        public Builder projects(JsonNullable<? extends List<TicketingProject>> projects) {
            Utils.checkNotNull(projects, "projects");
            this.projects = projects;
            return this;
        }


        /**
         * The unique ticket number or reference ID
         */
        public Builder ticketNumber(String ticketNumber) {
            Utils.checkNotNull(ticketNumber, "ticketNumber");
            this.ticketNumber = JsonNullable.of(ticketNumber);
            return this;
        }

        /**
         * The unique ticket number or reference ID
         */
        public Builder ticketNumber(JsonNullable<String> ticketNumber) {
            Utils.checkNotNull(ticketNumber, "ticketNumber");
            this.ticketNumber = ticketNumber;
            return this;
        }


        /**
         * The type of the ticket
         */
        public Builder type(TicketingReadTicketType type) {
            Utils.checkNotNull(type, "type");
            this.type = JsonNullable.of(type);
            return this;
        }

        /**
         * The type of the ticket
         */
        public Builder type(JsonNullable<? extends TicketingReadTicketType> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }


        /**
         * The date the ticket was closed
         */
        public Builder closedAt(OffsetDateTime closedAt) {
            Utils.checkNotNull(closedAt, "closedAt");
            this.closedAt = JsonNullable.of(closedAt);
            return this;
        }

        /**
         * The date the ticket was closed
         */
        public Builder closedAt(JsonNullable<OffsetDateTime> closedAt) {
            Utils.checkNotNull(closedAt, "closedAt");
            this.closedAt = closedAt;
            return this;
        }


        /**
         * URL to view the ticket in the source system
         */
        public Builder ticketUrl(String ticketUrl) {
            Utils.checkNotNull(ticketUrl, "ticketUrl");
            this.ticketUrl = JsonNullable.of(ticketUrl);
            return this;
        }

        /**
         * URL to view the ticket in the source system
         */
        public Builder ticketUrl(JsonNullable<String> ticketUrl) {
            Utils.checkNotNull(ticketUrl, "ticketUrl");
            this.ticketUrl = ticketUrl;
            return this;
        }


        /**
         * Current status of the ticket
         */
        public Builder status(TicketingReadTicketStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = JsonNullable.of(status);
            return this;
        }

        /**
         * Current status of the ticket
         */
        public Builder status(JsonNullable<? extends TicketingReadTicketStatus> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }


        /**
         * Organization associated with the ticket
         */
        public Builder organization(Organization organization) {
            Utils.checkNotNull(organization, "organization");
            this.organization = JsonNullable.of(organization);
            return this;
        }

        /**
         * Organization associated with the ticket
         */
        public Builder organization(JsonNullable<? extends Organization> organization) {
            Utils.checkNotNull(organization, "organization");
            this.organization = organization;
            return this;
        }


        /**
         * Components associated with the ticket
         */
        public Builder components(List<TicketingComponent> components) {
            Utils.checkNotNull(components, "components");
            this.components = JsonNullable.of(components);
            return this;
        }

        /**
         * Components associated with the ticket
         */
        public Builder components(JsonNullable<? extends List<TicketingComponent>> components) {
            Utils.checkNotNull(components, "components");
            this.components = components;
            return this;
        }


        /**
         * The timestamp when the record was created
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * The timestamp when the record was created
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }


        /**
         * The timestamp when the record was last updated
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * The timestamp when the record was last updated
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public TicketingReadTicket build() {

            return new TicketingReadTicket(
                id, remoteId, unifiedCustomFields,
                title, creatorId, reporters,
                assignees, content, parentId,
                priority, tags, projects,
                ticketNumber, type, closedAt,
                ticketUrl, status, organization,
                components, createdAt, updatedAt);
        }

    }
}
