/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import org.openapitools.jackson.nullable.JsonNullable;


public class StackoneGetConnectorMetaRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=provider")
    private String provider;

    /**
     * The comma separated list of data that will be included in the response
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=include")
    private JsonNullable<String> include;

    @JsonCreator
    public StackoneGetConnectorMetaRequest(
            String provider,
            JsonNullable<String> include) {
        Utils.checkNotNull(provider, "provider");
        Utils.checkNotNull(include, "include");
        this.provider = provider;
        this.include = include;
    }
    
    public StackoneGetConnectorMetaRequest(
            String provider) {
        this(provider, JsonNullable.undefined());
    }

    @JsonIgnore
    public String provider() {
        return provider;
    }

    /**
     * The comma separated list of data that will be included in the response
     */
    @JsonIgnore
    public JsonNullable<String> include() {
        return include;
    }

    public static Builder builder() {
        return new Builder();
    }


    public StackoneGetConnectorMetaRequest withProvider(String provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = provider;
        return this;
    }

    /**
     * The comma separated list of data that will be included in the response
     */
    public StackoneGetConnectorMetaRequest withInclude(String include) {
        Utils.checkNotNull(include, "include");
        this.include = JsonNullable.of(include);
        return this;
    }

    /**
     * The comma separated list of data that will be included in the response
     */
    public StackoneGetConnectorMetaRequest withInclude(JsonNullable<String> include) {
        Utils.checkNotNull(include, "include");
        this.include = include;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StackoneGetConnectorMetaRequest other = (StackoneGetConnectorMetaRequest) o;
        return 
            Utils.enhancedDeepEquals(this.provider, other.provider) &&
            Utils.enhancedDeepEquals(this.include, other.include);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            provider, include);
    }
    
    @Override
    public String toString() {
        return Utils.toString(StackoneGetConnectorMetaRequest.class,
                "provider", provider,
                "include", include);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String provider;

        private JsonNullable<String> include = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        public Builder provider(String provider) {
            Utils.checkNotNull(provider, "provider");
            this.provider = provider;
            return this;
        }


        /**
         * The comma separated list of data that will be included in the response
         */
        public Builder include(String include) {
            Utils.checkNotNull(include, "include");
            this.include = JsonNullable.of(include);
            return this;
        }

        /**
         * The comma separated list of data that will be included in the response
         */
        public Builder include(JsonNullable<String> include) {
            Utils.checkNotNull(include, "include");
            this.include = include;
            return this;
        }

        public StackoneGetConnectorMetaRequest build() {

            return new StackoneGetConnectorMetaRequest(
                provider, include);
        }

    }
}
