/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.TicketingAttachmentResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;


public class TicketingGetAttachmentResponse implements Response {
    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<InputStream> rawResponse;

    /**
     * The attachment with the given identifier was retrieved.
     */
    private Optional<? extends TicketingAttachmentResult> ticketingAttachmentResult;


    private Map<String, List<String>> headers;

    @JsonCreator
    public TicketingGetAttachmentResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Optional<? extends TicketingAttachmentResult> ticketingAttachmentResult,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(ticketingAttachmentResult, "ticketingAttachmentResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.ticketingAttachmentResult = ticketingAttachmentResult;
        this.headers = headers;
    }
    
    public TicketingGetAttachmentResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse,
            Optional.empty(), headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return rawResponse;
    }

    /**
     * The attachment with the given identifier was retrieved.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<TicketingAttachmentResult> ticketingAttachmentResult() {
        return (Optional<TicketingAttachmentResult>) ticketingAttachmentResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * HTTP response content type for this operation
     */
    public TicketingGetAttachmentResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public TicketingGetAttachmentResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public TicketingGetAttachmentResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * The attachment with the given identifier was retrieved.
     */
    public TicketingGetAttachmentResponse withTicketingAttachmentResult(TicketingAttachmentResult ticketingAttachmentResult) {
        Utils.checkNotNull(ticketingAttachmentResult, "ticketingAttachmentResult");
        this.ticketingAttachmentResult = Optional.ofNullable(ticketingAttachmentResult);
        return this;
    }


    /**
     * The attachment with the given identifier was retrieved.
     */
    public TicketingGetAttachmentResponse withTicketingAttachmentResult(Optional<? extends TicketingAttachmentResult> ticketingAttachmentResult) {
        Utils.checkNotNull(ticketingAttachmentResult, "ticketingAttachmentResult");
        this.ticketingAttachmentResult = ticketingAttachmentResult;
        return this;
    }

    public TicketingGetAttachmentResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TicketingGetAttachmentResponse other = (TicketingGetAttachmentResponse) o;
        return 
            Utils.enhancedDeepEquals(this.contentType, other.contentType) &&
            Utils.enhancedDeepEquals(this.statusCode, other.statusCode) &&
            Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) &&
            Utils.enhancedDeepEquals(this.ticketingAttachmentResult, other.ticketingAttachmentResult) &&
            Utils.enhancedDeepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            contentType, statusCode, rawResponse,
            ticketingAttachmentResult, headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(TicketingGetAttachmentResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "ticketingAttachmentResult", ticketingAttachmentResult,
                "headers", headers);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String contentType;

        private Integer statusCode;

        private HttpResponse<InputStream> rawResponse;

        private Optional<? extends TicketingAttachmentResult> ticketingAttachmentResult = Optional.empty();

        private Map<String, List<String>> headers;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }


        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }


        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }


        /**
         * The attachment with the given identifier was retrieved.
         */
        public Builder ticketingAttachmentResult(TicketingAttachmentResult ticketingAttachmentResult) {
            Utils.checkNotNull(ticketingAttachmentResult, "ticketingAttachmentResult");
            this.ticketingAttachmentResult = Optional.ofNullable(ticketingAttachmentResult);
            return this;
        }

        /**
         * The attachment with the given identifier was retrieved.
         */
        public Builder ticketingAttachmentResult(Optional<? extends TicketingAttachmentResult> ticketingAttachmentResult) {
            Utils.checkNotNull(ticketingAttachmentResult, "ticketingAttachmentResult");
            this.ticketingAttachmentResult = ticketingAttachmentResult;
            return this;
        }


        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public TicketingGetAttachmentResponse build() {

            return new TicketingGetAttachmentResponse(
                contentType, statusCode, rawResponse,
                ticketingAttachmentResult, headers);
        }

    }
}
