/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ScreeningPackageResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ScreeningGetScreeningPackageResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends ScreeningPackageResult> screeningPackageResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public ScreeningGetScreeningPackageResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends ScreeningPackageResult> screeningPackageResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(screeningPackageResult, "screeningPackageResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.screeningPackageResult = screeningPackageResult;
        this.headers = headers;
    }

    public ScreeningGetScreeningPackageResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<ScreeningPackageResult> screeningPackageResult() {
        return this.screeningPackageResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ScreeningGetScreeningPackageResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public ScreeningGetScreeningPackageResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public ScreeningGetScreeningPackageResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public ScreeningGetScreeningPackageResponse withScreeningPackageResult(ScreeningPackageResult screeningPackageResult) {
        Utils.checkNotNull(screeningPackageResult, "screeningPackageResult");
        this.screeningPackageResult = Optional.ofNullable(screeningPackageResult);
        return this;
    }

    public ScreeningGetScreeningPackageResponse withScreeningPackageResult(Optional<? extends ScreeningPackageResult> screeningPackageResult) {
        Utils.checkNotNull(screeningPackageResult, "screeningPackageResult");
        this.screeningPackageResult = screeningPackageResult;
        return this;
    }

    public ScreeningGetScreeningPackageResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScreeningGetScreeningPackageResponse other = (ScreeningGetScreeningPackageResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.screeningPackageResult, other.screeningPackageResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.screeningPackageResult, this.headers);
    }

    public String toString() {
        return Utils.toString(ScreeningGetScreeningPackageResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "screeningPackageResult", this.screeningPackageResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends ScreeningPackageResult> screeningPackageResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder screeningPackageResult(ScreeningPackageResult screeningPackageResult) {
            Utils.checkNotNull(screeningPackageResult, "screeningPackageResult");
            this.screeningPackageResult = Optional.ofNullable(screeningPackageResult);
            return this;
        }

        public Builder screeningPackageResult(Optional<? extends ScreeningPackageResult> screeningPackageResult) {
            Utils.checkNotNull(screeningPackageResult, "screeningPackageResult");
            this.screeningPackageResult = screeningPackageResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public ScreeningGetScreeningPackageResponse build() {
            return new ScreeningGetScreeningPackageResponse(this.contentType, this.statusCode, this.rawResponse, this.screeningPackageResult, this.headers);
        }
    }
}

