/*
 * Decompiled with CFR 0.152.
 */
package com.strongloop.android.loopback;

import com.strongloop.android.loopback.BeanUtil;
import com.strongloop.android.loopback.Model;
import com.strongloop.android.remoting.JsonUtil;
import com.strongloop.android.remoting.Repository;
import com.strongloop.android.remoting.adapters.Adapter;
import com.strongloop.android.remoting.adapters.RestContract;
import com.strongloop.android.remoting.adapters.RestContractItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.atteo.evo.inflector.English;
import org.json.JSONArray;
import org.json.JSONObject;

public class ModelRepository<T extends Model>
extends Repository {
    private Class<T> modelClass;
    private String nameForRestUrl;

    public ModelRepository(String className) {
        this(className, null);
    }

    public ModelRepository(String className, Class<T> modelClass) {
        this(className, null, modelClass);
    }

    public ModelRepository(String className, String nameForRestUrl, Class<T> modelClass) {
        super(className);
        this.nameForRestUrl = nameForRestUrl != null ? nameForRestUrl : English.plural((String)className);
        this.modelClass = modelClass == null ? Model.class : modelClass;
    }

    public RestContract createContract() {
        RestContract contract = new RestContract();
        String className = this.getClassName();
        contract.addItem(new RestContractItem("/" + this.nameForRestUrl, "POST"), className + ".prototype.create");
        contract.addItem(new RestContractItem("/" + this.nameForRestUrl + "/:id", "PUT"), className + ".prototype.save");
        contract.addItem(new RestContractItem("/" + this.nameForRestUrl + "/:id", "DELETE"), className + ".prototype.remove");
        contract.addItem(new RestContractItem("/" + this.nameForRestUrl + "/:id", "GET"), className + ".findById");
        contract.addItem(new RestContractItem("/" + this.nameForRestUrl, "GET"), className + ".all");
        return contract;
    }

    public T createModel(Map<String, ? extends Object> parameters) {
        if (parameters == null) {
            parameters = new HashMap<String, Object>();
        }
        Model model = null;
        try {
            model = (Model)((Object)this.modelClass.newInstance());
        }
        catch (Exception e) {
            IllegalArgumentException ex = new IllegalArgumentException();
            ex.initCause(e);
            throw ex;
        }
        model.setRepository(this);
        model.setCreationParameters(parameters);
        model.putAll(parameters);
        BeanUtil.setProperties((Object)model, parameters, true);
        Object id = parameters.get("id");
        if (id != null) {
            model.setId(id);
        }
        return (T)((Object)model);
    }

    public void findById(Object id, final FindCallback<T> callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        this.invokeStaticMethod("findById", params, (Adapter.Callback)new Adapter.JsonObjectCallback(){

            public void onError(Throwable t) {
                callback.onError(t);
            }

            public void onSuccess(JSONObject response) {
                if (response == null) {
                    callback.onSuccess(null);
                } else {
                    callback.onSuccess(ModelRepository.this.createModel(JsonUtil.fromJson((JSONObject)response)));
                }
            }
        });
    }

    public void findAll(final FindAllCallback<T> callback) {
        this.invokeStaticMethod("all", null, (Adapter.Callback)new Adapter.JsonArrayCallback(){

            public void onError(Throwable t) {
                callback.onError(t);
            }

            public void onSuccess(JSONArray response) {
                ArrayList list = new ArrayList();
                if (response != null) {
                    for (int i = 0; i < response.length(); ++i) {
                        list.add(ModelRepository.this.createModel(JsonUtil.fromJson((JSONObject)response.optJSONObject(i))));
                    }
                }
                callback.onSuccess(list);
            }
        });
    }

    public static interface FindAllCallback<T extends Model> {
        public void onSuccess(List<T> var1);

        public void onError(Throwable var1);
    }

    public static interface FindCallback<T extends Model> {
        public void onSuccess(T var1);

        public void onError(Throwable var1);
    }
}

