/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.client;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.sumologic.client.Credentials;
import com.sumologic.client.SumoClientException;
import com.sumologic.client.SumoLogic;
import com.sumologic.client.SumoServerException;
import com.sumologic.client.model.LogMessage;
import com.sumologic.client.model.SearchRequest;
import com.sumologic.client.model.SearchResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.impl.client.DefaultHttpClient;

public class SumoLogicClient
implements SumoLogic {
    private int port = 443;
    private String protocol = "https";
    private String hostname = "service.sumologic.com";
    private Credentials credentials;
    private static JsonFactory jsonFactory = new JsonFactory();

    public SumoLogicClient(Credentials credentials) {
        this.credentials = credentials;
    }

    public SumoLogicClient(String email, String password) {
        this.credentials = new Credentials(email, password);
    }

    public void setURL(String urlString) throws MalformedURLException {
        URL url = new URL(urlString);
        this.hostname = url.getHost();
        this.port = url.getPort() == -1 ? (url.getDefaultPort() == -1 ? 80 : url.getDefaultPort()) : url.getPort();
        this.protocol = url.getProtocol();
    }

    @Override
    public SearchResponse search(SearchRequest request) {
        SearchResponse searchResponse;
        block28: {
            DefaultHttpClient httpClient = new DefaultHttpClient();
            httpClient.getCredentialsProvider().setCredentials(new AuthScope(this.hostname, this.port), (org.apache.http.auth.Credentials)new UsernamePasswordCredentials(this.credentials.getEmail(), this.credentials.getPassword()));
            HttpGet searchGetMethod = null;
            InputStream httpStream = null;
            JsonParser jp = null;
            searchResponse = null;
            try {
                searchGetMethod = new HttpGet(URIUtils.createURI((String)this.protocol, (String)(this.hostname + ":" + this.port), (int)-1, (String)"/api/v1/logs/search", (String)request.toString(), null));
                HttpResponse response = httpClient.execute((HttpUriRequest)searchGetMethod);
                HttpEntity entity = response.getEntity();
                httpStream = entity.getContent();
                if (response.getStatusLine().getStatusCode() == 200) {
                    searchResponse = new SearchResponse(request);
                    jp = jsonFactory.createJsonParser(httpStream);
                    if (jp.nextToken() != JsonToken.START_ARRAY) {
                        SearchResponse searchResponse2 = searchResponse;
                        return searchResponse2;
                    }
                    while (jp.nextToken() == JsonToken.START_OBJECT) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        while (jp.nextToken() != JsonToken.END_OBJECT) {
                            String key = jp.getCurrentName();
                            jp.nextToken();
                            String value = jp.getText();
                            map.put(key, value);
                        }
                        searchResponse.getMessages().add(new LogMessage(map));
                    }
                    break block28;
                }
                StringWriter writer = new StringWriter();
                BufferedReader reader = new BufferedReader(new InputStreamReader(httpStream));
                String s = null;
                while ((s = reader.readLine()) != null) {
                    writer.write(s + "\n");
                }
                throw new SumoServerException(searchGetMethod.getURI().toString(), writer.toString());
            }
            catch (IOException ex) {
                throw new SumoClientException("Error reading server response", ex);
            }
            catch (RuntimeException ex) {
                throw new SumoClientException("Runtime error reading server response", ex);
            }
            catch (URISyntaxException ex) {
                throw new SumoClientException("URI cannot be generated", ex);
            }
            finally {
                if (jp != null) {
                    try {
                        jp.close();
                    }
                    catch (IOException io) {}
                }
                httpClient.getConnectionManager().shutdown();
                if (httpStream != null) {
                    try {
                        httpStream.close();
                    }
                    catch (IOException io) {}
                }
                if (searchGetMethod != null) {
                    searchGetMethod.abort();
                }
            }
        }
        return searchResponse;
    }

    public SearchResponse search(String query) {
        return this.search(new SearchRequest(query));
    }
}

