/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.client.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LogMessage {
    private Map<String, String> properties = new HashMap<String, String>();

    @JsonAnyGetter
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonAnySetter
    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public final Set<String> getFieldNames() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public final String stringField(String key) {
        return this.properties.get(key);
    }

    public final long longField(String key) throws NumberFormatException {
        return Long.parseLong(this.properties.get(key));
    }

    public final double doubleField(String key) throws NumberFormatException {
        return Double.parseDouble(this.properties.get(key));
    }

    public final Date dateField(String key) throws NumberFormatException {
        return new Date(this.longField(key));
    }

    public final String getLogLine() {
        return this.stringField("_raw");
    }

    public final Date getTime() {
        return this.dateField("_messagetime");
    }

    public final Date getReceiptTime() {
        return this.dateField("_receipttime");
    }

    public final String getSourceHost() {
        return this.stringField("_sourcehost");
    }

    public final String getSourceCategory() {
        return this.stringField("_sourcecategory");
    }

    public final String getSourceName() {
        return this.stringField("_sourcename");
    }

    public final long getLineCount() {
        return this.longField("_count");
    }

    public final String getSignature() {
        return this.stringField("_signature");
    }

    public Map<String, String> getMap() {
        return this.properties;
    }

    public void setMap(Map<String, String> map) {
        this.properties = map;
    }

    public String toString() {
        return this.getLogLine();
    }
}

