/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.client.util;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.sumologic.client.ConnectionConfig;
import com.sumologic.client.SumoClientException;
import com.sumologic.client.SumoServerException;
import com.sumologic.client.model.HttpDeleteRequest;
import com.sumologic.client.model.HttpGetRequest;
import com.sumologic.client.model.HttpPostRequest;
import com.sumologic.client.model.HttpPutRequest;
import com.sumologic.client.util.JacksonUtils;
import com.sumologic.client.util.ResponseHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class HttpUtils {
    public static final int API_VERSION = 1;
    private static final String JSON_CONTENT_TYPE = "application/json";
    private final CookieStore cookieStore = new BasicCookieStore();

    public <Request extends HttpGetRequest, Response> Response get(ConnectionConfig config, String endpoint, Request request, Map<String, String> requestHeaders, ResponseHandler<Request, Response> handler, int expectedStatusCode) {
        return this.get(config, endpoint, request, 60000, requestHeaders, handler, expectedStatusCode);
    }

    public <Request extends HttpGetRequest, Response> Response get(ConnectionConfig config, String endpoint, Request request, int timeout, Map<String, String> requestHeaders, ResponseHandler<Request, Response> handler, int expectedStatusCode) {
        try {
            URI uri = new URIBuilder().setScheme(config.getProtocol()).setHost(config.getHostname()).setPort(config.getPort()).setPath(HttpUtils.getEndpointURI(endpoint)).setParameters(request.toUrlParams()).setCharset(StandardCharsets.UTF_8).build();
            HttpGet get = new HttpGet(uri);
            this.configureRequest(config, (HttpRequestBase)get, timeout);
            return this.doRequest(config, timeout, (HttpUriRequest)get, requestHeaders, request, handler, expectedStatusCode);
        }
        catch (URISyntaxException e) {
            throw new SumoClientException("URI cannot be generated", e);
        }
    }

    public <Request extends HttpPostRequest, Response> Response post(ConnectionConfig config, String endpoint, Request request, Map<String, String> requestHeaders, ResponseHandler<Request, Response> handler, int expectedStatusCode) {
        try {
            URI uri = new URIBuilder().setScheme(config.getProtocol()).setHost(config.getHostname()).setPort(config.getPort()).setPath(HttpUtils.getEndpointURI(endpoint)).setCharset(StandardCharsets.UTF_8).build();
            HttpPost post = new HttpPost(uri);
            this.configureRequest(config, (HttpRequestBase)post, 60000);
            String body = JacksonUtils.MAPPER.writeValueAsString(request);
            StringEntity entity = new StringEntity(body, StandardCharsets.UTF_8);
            entity.setContentType(JSON_CONTENT_TYPE);
            post.setEntity((HttpEntity)entity);
            return this.doRequest(config, (HttpUriRequest)post, requestHeaders, request, handler, expectedStatusCode);
        }
        catch (URISyntaxException e) {
            throw new SumoClientException("URI cannot be generated", e);
        }
        catch (JsonGenerationException | JsonMappingException e) {
            throw new SumoClientException("Error generating JSON", e);
        }
        catch (IOException e) {
            throw new SumoClientException("Error generating JSON", e);
        }
    }

    public <Request extends HttpPutRequest, Response> Response put(ConnectionConfig config, String endpoint, Request request, ResponseHandler<Request, Response> handler, int expectedStatusCode) {
        try {
            URI uri = new URIBuilder().setScheme(config.getProtocol()).setHost(config.getHostname()).setPort(config.getPort()).setPath(HttpUtils.getEndpointURI(endpoint)).build();
            HttpPut put = new HttpPut(uri);
            HashMap<String, String> requestHeaders = new HashMap<String, String>();
            if (request.getETag() != null) {
                requestHeaders.put("If-Match", request.getETag());
            }
            String body = JacksonUtils.MAPPER.writeValueAsString(request);
            StringEntity entity = new StringEntity(body, StandardCharsets.UTF_8);
            entity.setContentType(JSON_CONTENT_TYPE);
            put.setEntity((HttpEntity)entity);
            this.configureRequest(config, (HttpRequestBase)put, 60000);
            return this.doRequest(config, (HttpUriRequest)put, requestHeaders, request, handler, expectedStatusCode);
        }
        catch (URISyntaxException ex) {
            throw new SumoClientException("URI cannot be generated", ex);
        }
        catch (JsonGenerationException | JsonMappingException e) {
            throw new SumoClientException("Error generating JSON", e);
        }
        catch (IOException e) {
            throw new SumoClientException("Error generating JSON", e);
        }
    }

    public <Request extends HttpDeleteRequest, Response> Response delete(ConnectionConfig config, String endpoint, Request request, ResponseHandler<Request, Response> handler, int expectedStatusCode) {
        try {
            URI uri = new URIBuilder().setScheme(config.getProtocol()).setHost(config.getHostname()).setPort(config.getPort()).setPath(HttpUtils.getEndpointURI(endpoint)).build();
            HttpDelete delete = new HttpDelete(uri);
            this.configureRequest(config, (HttpRequestBase)delete, 60000);
            Map<String, String> requestHeaders = HttpUtils.toRequestHeaders(new String[0]);
            return this.doRequest(config, (HttpUriRequest)delete, requestHeaders, request, handler, expectedStatusCode);
        }
        catch (URISyntaxException ex) {
            throw new SumoClientException("URI cannot be generated", ex);
        }
    }

    public static Map<String, String> toRequestHeaders(String ... parts) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < parts.length; ++i) {
            result.put(parts[i], parts[++i]);
        }
        return result;
    }

    private CloseableHttpClient getHttpClient(ConnectionConfig config) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(config.getAuthScope(), (Credentials)config.getUsernamePasswordCredentials());
        return HttpClients.custom().setDefaultCookieStore(this.cookieStore).setDefaultCredentialsProvider((CredentialsProvider)provider).build();
    }

    private static String getEndpointURI(String endpoint) {
        return "/api/v1/" + endpoint;
    }

    private <Request, Response> Response doRequest(ConnectionConfig config, HttpUriRequest method, Map<String, String> requestHeaders, Request request, ResponseHandler<Request, Response> handler, int expectedStatusCode) {
        return this.doRequest(config, 60000, method, requestHeaders, request, handler, expectedStatusCode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <Request, Response> Response doRequest(ConnectionConfig config, int timeout, HttpUriRequest method, Map<String, String> requestHeaders, Request request, ResponseHandler<Request, Response> handler, int expectedStatusCode) {
        for (Map.Entry<String, String> header : requestHeaders.entrySet()) {
            method.setHeader(header.getKey(), header.getValue());
        }
        CloseableHttpClient httpClient = this.getHttpClient(config);
        InputStream httpStream = null;
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = httpClient.execute(method);
            HttpEntity entity = httpResponse.getEntity();
            httpStream = entity.getContent();
            if (httpResponse.getStatusLine().getStatusCode() == expectedStatusCode) {
                Response Response = handler.handle((HttpResponse)httpResponse, httpStream, request);
                return Response;
            }
            StringWriter writer = new StringWriter();
            BufferedReader reader = new BufferedReader(new InputStreamReader(httpStream));
            while (true) {
                String s;
                if ((s = reader.readLine()) == null) {
                    String json = writer.toString();
                    if (!JacksonUtils.isValidJson(json)) throw new SumoServerException(method.getURI().toString(), httpResponse.getStatusLine().getStatusCode());
                    throw new SumoServerException(method.getURI().toString(), writer.toString());
                }
                writer.write(s + "\n");
            }
        }
        catch (IOException ex) {
            throw new SumoClientException("Error reading server response", ex);
        }
        catch (RuntimeException ex) {
            if (!(ex instanceof SumoServerException)) throw new SumoClientException("Runtime error reading server response", ex);
            throw ex;
        }
        finally {
            if (httpStream != null) {
                try {
                    httpStream.close();
                }
                catch (Exception exception) {}
            }
            if (method != null) {
                try {
                    method.abort();
                }
                catch (Exception exception) {}
            }
            try {
                httpResponse.close();
            }
            catch (Exception exception) {}
            try {
                httpClient.close();
            }
            catch (Exception exception) {}
        }
    }

    private void configureRequest(ConnectionConfig config, HttpRequestBase request, int timeout) {
        RequestConfig.Builder builder = RequestConfig.custom().setConnectTimeout(timeout).setSocketTimeout(timeout);
        builder.setCookieSpec("standard");
        if (config.getProxy() != null) {
            builder.setProxy(config.getProxy()).build();
        }
        request.setConfig(builder.build());
    }
}

