/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.client;

import com.sumologic.client.ConnectionConfig;
import com.sumologic.client.Credentials;
import com.sumologic.client.SumoLogic;
import com.sumologic.client.collectors.CollectorsClient;
import com.sumologic.client.collectors.model.Collector;
import com.sumologic.client.collectors.model.CreateCollectorRequest;
import com.sumologic.client.collectors.model.CreateCollectorResponse;
import com.sumologic.client.collectors.model.CreateSourceRequest;
import com.sumologic.client.collectors.model.CreateSourceResponse;
import com.sumologic.client.collectors.model.DeleteCollectorRequest;
import com.sumologic.client.collectors.model.DeleteCollectorResponse;
import com.sumologic.client.collectors.model.DeleteSourceRequest;
import com.sumologic.client.collectors.model.DeleteSourceResponse;
import com.sumologic.client.collectors.model.GetCollectorRequest;
import com.sumologic.client.collectors.model.GetCollectorResponse;
import com.sumologic.client.collectors.model.GetCollectorsRequest;
import com.sumologic.client.collectors.model.GetCollectorsResponse;
import com.sumologic.client.collectors.model.GetSourceRequest;
import com.sumologic.client.collectors.model.GetSourceResponse;
import com.sumologic.client.collectors.model.GetSourcesRequest;
import com.sumologic.client.collectors.model.GetSourcesResponse;
import com.sumologic.client.collectors.model.Source;
import com.sumologic.client.collectors.model.UpdateCollectorRequest;
import com.sumologic.client.collectors.model.UpdateCollectorResponse;
import com.sumologic.client.collectors.model.UpdateSourceRequest;
import com.sumologic.client.collectors.model.UpdateSourceResponse;
import com.sumologic.client.dashboard.DashboardClient;
import com.sumologic.client.dashboard.model.GetDashboardDataRequest;
import com.sumologic.client.dashboard.model.GetDashboardDataResponse;
import com.sumologic.client.dashboard.model.GetDashboardRequest;
import com.sumologic.client.dashboard.model.GetDashboardResponse;
import com.sumologic.client.dashboard.model.GetDashboardsRequest;
import com.sumologic.client.dashboard.model.GetDashboardsResponse;
import com.sumologic.client.searchjob.SearchJobClient;
import com.sumologic.client.searchjob.model.CancelSearchJobRequest;
import com.sumologic.client.searchjob.model.CancelSearchJobResponse;
import com.sumologic.client.searchjob.model.CreateSearchJobRequest;
import com.sumologic.client.searchjob.model.GetMessagesForSearchJobRequest;
import com.sumologic.client.searchjob.model.GetMessagesForSearchJobResponse;
import com.sumologic.client.searchjob.model.GetRecordsForSearchJobRequest;
import com.sumologic.client.searchjob.model.GetRecordsForSearchJobResponse;
import com.sumologic.client.searchjob.model.GetSearchJobStatusRequest;
import com.sumologic.client.searchjob.model.GetSearchJobStatusResponse;
import com.sumologic.client.util.HttpUtils;
import java.net.MalformedURLException;
import java.net.URL;

public class SumoLogicClient
implements SumoLogic {
    private final HttpUtils httpUtils = new HttpUtils();
    private String protocol = "https";
    private String hostname = "api.sumologic.com";
    private int port = 443;
    private final Credentials credentials;
    private String proxyHost;
    private int proxyPort;
    private String proxyProtocol;
    private final CollectorsClient collectorsClient = new CollectorsClient(this.httpUtils);
    private final SearchJobClient searchJobClient = new SearchJobClient(this.httpUtils);
    private final DashboardClient dashboardClient = new DashboardClient(this.httpUtils);

    public SumoLogicClient(Credentials credentials) {
        this.credentials = credentials;
    }

    public SumoLogicClient(String accessId, String accessKey) {
        this.credentials = new Credentials(accessId, accessKey);
    }

    public void setURL(String urlString) throws MalformedURLException {
        URL url = new URL(urlString);
        this.hostname = url.getHost();
        this.port = url.getPort() == -1 ? (url.getDefaultPort() == -1 ? 80 : url.getDefaultPort()) : url.getPort();
        this.protocol = url.getProtocol();
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setProxyProtocol(String proxyProtocol) {
        this.proxyProtocol = proxyProtocol;
    }

    private ConnectionConfig getConnectionConfig() {
        return new ConnectionConfig(this.protocol, this.hostname, this.port, this.credentials, this.proxyProtocol, this.proxyHost, this.proxyPort);
    }

    @Override
    public String createSearchJob(String query, String fromExpression, String toExpression, String timeZone) {
        return this.createSearchJob(query, fromExpression, toExpression, timeZone, "false");
    }

    @Override
    public String createSearchJob(String query, String fromExpression, String toExpression, String timeZone, String byReceiptTime) {
        CreateSearchJobRequest createSearchJobRequest = new CreateSearchJobRequest(query, fromExpression, toExpression, timeZone, byReceiptTime);
        return this.searchJobClient.createSearchJob(this.getConnectionConfig(), createSearchJobRequest);
    }

    @Override
    public GetSearchJobStatusResponse getSearchJobStatus(String searchJobId) {
        GetSearchJobStatusRequest getSearchJobStatusRequest = new GetSearchJobStatusRequest(searchJobId);
        return this.searchJobClient.getSearchJobStatus(this.getConnectionConfig(), getSearchJobStatusRequest);
    }

    @Override
    public GetMessagesForSearchJobResponse getMessagesForSearchJob(String searchJobId, int offset, int limit) {
        GetMessagesForSearchJobRequest getMessagesForSearchJobRequest = new GetMessagesForSearchJobRequest(searchJobId, offset, limit);
        return this.searchJobClient.getMessagesForSearchJob(this.getConnectionConfig(), getMessagesForSearchJobRequest);
    }

    @Override
    public GetRecordsForSearchJobResponse getRecordsForSearchJob(String searchJobId, int offset, int limit) {
        GetRecordsForSearchJobRequest getRecordsForSearchJobRequest = new GetRecordsForSearchJobRequest(searchJobId, offset, limit);
        return this.searchJobClient.getRecordsForSearchJob(this.getConnectionConfig(), getRecordsForSearchJobRequest);
    }

    @Override
    public CancelSearchJobResponse cancelSearchJob(String searchJobId) {
        CancelSearchJobRequest cancelSearchJobRequest = new CancelSearchJobRequest(searchJobId);
        return this.searchJobClient.deleteSearchJob(this.getConnectionConfig(), cancelSearchJobRequest);
    }

    @Override
    public GetCollectorsResponse getCollectors(GetCollectorsRequest request) {
        return this.collectorsClient.get(this.getConnectionConfig(), request);
    }

    @Override
    public GetCollectorsResponse getCollectors() {
        return this.getCollectors(new GetCollectorsRequest());
    }

    @Override
    public GetCollectorResponse getCollector(GetCollectorRequest request) {
        return this.collectorsClient.get(this.getConnectionConfig(), request);
    }

    @Override
    public GetCollectorResponse getCollector(Long id) {
        return this.getCollector(new GetCollectorRequest(id));
    }

    @Override
    public CreateCollectorResponse createCollector(CreateCollectorRequest request) {
        return this.collectorsClient.create(this.getConnectionConfig(), request);
    }

    @Override
    public CreateCollectorResponse createCollector(Collector collector) {
        return this.createCollector(new CreateCollectorRequest(collector));
    }

    @Override
    public UpdateCollectorResponse updateCollector(UpdateCollectorRequest request) {
        return this.collectorsClient.update(this.getConnectionConfig(), request);
    }

    @Override
    public UpdateCollectorResponse updateCollector(Collector collector) {
        return this.updateCollector(new UpdateCollectorRequest(collector.getId(), collector));
    }

    @Override
    public DeleteCollectorResponse deleteCollector(DeleteCollectorRequest request) {
        return this.collectorsClient.delete(this.getConnectionConfig(), request);
    }

    @Override
    public DeleteCollectorResponse deleteCollector(Long id) {
        return this.deleteCollector(new DeleteCollectorRequest(id));
    }

    @Override
    public GetSourcesResponse getSources(GetSourcesRequest request) {
        return this.collectorsClient.getSources(this.getConnectionConfig(), request);
    }

    @Override
    public GetSourcesResponse getSources(Long collectorId) {
        return this.getSources(new GetSourcesRequest(collectorId));
    }

    @Override
    public GetSourceResponse getSource(GetSourceRequest request) {
        return this.collectorsClient.getSource(this.getConnectionConfig(), request);
    }

    @Override
    public GetSourceResponse getSource(Long collectorId, Long sourceId) {
        return this.getSource(new GetSourceRequest(collectorId, sourceId));
    }

    @Override
    public CreateSourceResponse createSource(CreateSourceRequest request) {
        return this.collectorsClient.createSource(this.getConnectionConfig(), request);
    }

    @Override
    public CreateSourceResponse createSource(Long collectorId, Source source) {
        return this.createSource(new CreateSourceRequest(collectorId, source));
    }

    @Override
    public UpdateSourceResponse updateSource(UpdateSourceRequest request) {
        return this.collectorsClient.updateSource(this.getConnectionConfig(), request);
    }

    @Override
    public UpdateSourceResponse updateSource(Long collectorId, Source source) {
        return this.updateSource(new UpdateSourceRequest(collectorId, source.getId(), source));
    }

    @Override
    public DeleteSourceResponse deleteSource(DeleteSourceRequest request) {
        return this.collectorsClient.deleteSource(this.getConnectionConfig(), request);
    }

    @Override
    public DeleteSourceResponse deleteSource(Long collectorId, Long sourceId) {
        return this.deleteSource(new DeleteSourceRequest(collectorId, sourceId));
    }

    public GetDashboardsResponse getDashboards(boolean includeMonitors) {
        return this.dashboardClient.getDashboards(this.getConnectionConfig(), new GetDashboardsRequest(includeMonitors));
    }

    public GetDashboardDataResponse getDashboardData(long id) {
        return this.dashboardClient.getDashboardData(this.getConnectionConfig(), new GetDashboardDataRequest(id));
    }

    public GetDashboardResponse getDashboard(long id) {
        return this.dashboardClient.getDashboard(this.getConnectionConfig(), new GetDashboardRequest(id));
    }
}

