/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.client.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class JacksonUtils {
    public static final ObjectMapper MAPPER = new ObjectMapper();

    public static Long asLong(Object value) {
        if (value == null) {
            return null;
        }
        return ((Number)value).longValue();
    }

    public static Double asDouble(Object value) {
        if (value == null) {
            return null;
        }
        return ((Number)value).doubleValue();
    }

    public static boolean isValidJson(String json) {
        try {
            MAPPER.readValue(json, JsonNode.class);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

