/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.client.searchjob;

import com.sumologic.client.ConnectionConfig;
import com.sumologic.client.searchjob.model.CancelSearchJobRequest;
import com.sumologic.client.searchjob.model.CancelSearchJobResponse;
import com.sumologic.client.searchjob.model.CreateSearchJobRequest;
import com.sumologic.client.searchjob.model.CreateSearchJobResponse;
import com.sumologic.client.searchjob.model.GetMessagesForSearchJobRequest;
import com.sumologic.client.searchjob.model.GetMessagesForSearchJobResponse;
import com.sumologic.client.searchjob.model.GetRecordsForSearchJobRequest;
import com.sumologic.client.searchjob.model.GetRecordsForSearchJobResponse;
import com.sumologic.client.searchjob.model.GetSearchJobStatusRequest;
import com.sumologic.client.searchjob.model.GetSearchJobStatusResponse;
import com.sumologic.client.util.DeserializingResponseHandler;
import com.sumologic.client.util.HttpUtils;

public class SearchJobClient {
    private final HttpUtils httpUtils;

    public SearchJobClient(HttpUtils httpUtils) {
        this.httpUtils = httpUtils;
    }

    public String createSearchJob(ConnectionConfig connection, CreateSearchJobRequest createSearchJobRequest) {
        String uri = "search/jobs";
        return this.httpUtils.post(connection, uri, createSearchJobRequest, HttpUtils.toRequestHeaders("Content-type", "application/json", "Accept", "application/json"), new DeserializingResponseHandler(CreateSearchJobResponse.class), 202).getId();
    }

    public GetSearchJobStatusResponse getSearchJobStatus(ConnectionConfig connection, GetSearchJobStatusRequest getSearchJobStatusRequest) {
        String uri = "search/jobs/" + getSearchJobStatusRequest.getId();
        return this.httpUtils.get(connection, uri, getSearchJobStatusRequest, HttpUtils.toRequestHeaders("Accept", "application/json"), new DeserializingResponseHandler(GetSearchJobStatusResponse.class), 200);
    }

    public GetMessagesForSearchJobResponse getMessagesForSearchJob(ConnectionConfig connection, GetMessagesForSearchJobRequest getMessagesForSearchJobRequest) {
        String uri = "search/jobs/" + getMessagesForSearchJobRequest.getId() + "/" + "messages";
        return this.httpUtils.get(connection, uri, getMessagesForSearchJobRequest, HttpUtils.toRequestHeaders("Accept", "application/json"), new DeserializingResponseHandler(GetMessagesForSearchJobResponse.class), 200);
    }

    public GetRecordsForSearchJobResponse getRecordsForSearchJob(ConnectionConfig connection, GetRecordsForSearchJobRequest getRecordsForSearchJobRequest) {
        String uri = "search/jobs/" + getRecordsForSearchJobRequest.getId() + "/" + "records";
        return this.httpUtils.get(connection, uri, getRecordsForSearchJobRequest, HttpUtils.toRequestHeaders("Accept", "application/json"), new DeserializingResponseHandler(GetRecordsForSearchJobResponse.class), 200);
    }

    public CancelSearchJobResponse deleteSearchJob(ConnectionConfig connection, CancelSearchJobRequest cancelSearchJobRequest) {
        String uri = "search/jobs/" + cancelSearchJobRequest.getId();
        return this.httpUtils.delete(connection, uri, cancelSearchJobRequest, new DeserializingResponseHandler(CancelSearchJobResponse.class), 200);
    }
}

