/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.client.searchjob;

import com.sumologic.client.Credentials;
import com.sumologic.client.SumoLogicClient;
import com.sumologic.client.model.LogMessage;
import com.sumologic.client.searchjob.model.GetMessagesForSearchJobResponse;
import com.sumologic.client.searchjob.model.GetSearchJobStatusResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;

public class SearchJobExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) throws Exception {
        block16: {
            int messageCount;
            String searchJobId;
            SumoLogicClient sumoClient;
            block15: {
                String url = "http://localhost:23667";
                String accessId = SearchJobExample.read("AccessId");
                String accessKey = SearchJobExample.read("AccessKey");
                Credentials credential = new Credentials(accessId, accessKey);
                sumoClient = new SumoLogicClient(credential);
                sumoClient.setURL(url);
                searchJobId = sumoClient.createSearchJob("* | count _sourceHost", "2013-03-10T13:10:00", "2013-03-10T13:11:00", "america/los_angeles");
                System.out.printf("Search job ID: '%s'\n", searchJobId);
                messageCount = 0;
                int recordCount = 0;
                GetSearchJobStatusResponse getSearchJobStatusResponse = null;
                while (getSearchJobStatusResponse == null || !getSearchJobStatusResponse.getState().equals("DONE GATHERING RESULTS") && !getSearchJobStatusResponse.getState().equals("CANCELLED")) {
                    Thread.sleep(5000L);
                    getSearchJobStatusResponse = sumoClient.getSearchJobStatus(searchJobId);
                    messageCount = getSearchJobStatusResponse.getMessageCount();
                    recordCount = getSearchJobStatusResponse.getRecordCount();
                    System.out.printf("Search job ID: '%s', %s\n", searchJobId, getSearchJobStatusResponse);
                }
                if (!getSearchJobStatusResponse.getState().equals("CANCELLED")) break block15;
                System.out.println("Ugh. Search job was cancelled. Exiting...");
                try {
                    sumoClient.cancelSearchJob(searchJobId);
                }
                catch (Throwable t) {
                    System.out.printf("Error cancelling search job: '%s'", t.getMessage());
                    t.printStackTrace();
                }
                return;
            }
            int messageOffset = 0;
            int messageLength = Math.min(messageCount, 10);
            GetMessagesForSearchJobResponse getMessagesForSearchJobResponse = sumoClient.getMessagesForSearchJob(searchJobId, messageOffset, messageLength);
            System.out.printf("Messages for search job ID: '%s', %s\n", searchJobId, getMessagesForSearchJobResponse);
            List<LogMessage> messages = getMessagesForSearchJobResponse.getMessages();
            for (LogMessage message : messages) {
                System.out.printf("  %s, %s, %s, %s, %s\n", message.getTime(), message.getSourceHost(), message.getSourceName(), message.getSourceCategory(), message.getLogLine());
            }
            try {
                sumoClient.cancelSearchJob(searchJobId);
            }
            catch (Throwable t) {
                System.out.printf("Error cancelling search job: '%s'", t.getMessage());
                t.printStackTrace();
            }
            break block16;
            catch (Throwable t) {
                try {
                    t.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        sumoClient.cancelSearchJob(searchJobId);
                    }
                    catch (Throwable t2) {
                        System.out.printf("Error cancelling search job: '%s'", t2.getMessage());
                        t2.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    sumoClient.cancelSearchJob(searchJobId);
                }
                catch (Throwable t3) {
                    System.out.printf("Error cancelling search job: '%s'", t3.getMessage());
                    t3.printStackTrace();
                }
            }
        }
    }

    private static String read(String prompt) {
        System.out.print(prompt + ": ");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        try {
            return br.readLine();
        }
        catch (IOException ioe) {
            System.out.println("IO error trying to read your name!");
            System.exit(1);
            return null;
        }
    }
}

