/*
 * Decompiled with CFR 0.152.
 */
package org.redmine.ta.internal;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.redmine.ta.RedmineInternalError;
import org.redmine.ta.beans.Attachment;
import org.redmine.ta.beans.Issue;
import org.redmine.ta.beans.IssueCategory;
import org.redmine.ta.beans.IssueRelation;
import org.redmine.ta.beans.IssueStatus;
import org.redmine.ta.beans.Membership;
import org.redmine.ta.beans.News;
import org.redmine.ta.beans.Project;
import org.redmine.ta.beans.Role;
import org.redmine.ta.beans.SavedQuery;
import org.redmine.ta.beans.TimeEntry;
import org.redmine.ta.beans.Tracker;
import org.redmine.ta.beans.User;
import org.redmine.ta.beans.Version;

public class URIConfigurator {
    private static final String URL_POSTFIX = ".json";
    private static final Map<Class<?>, String> urls = new HashMap();
    private final URL baseURL;
    private final String apiAccessKey;

    public URIConfigurator(String host, String apiAccessKey) {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("The host parameter is NULL or empty");
        }
        try {
            this.baseURL = new URL(host);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Illegal host URL " + host, e);
        }
        this.apiAccessKey = apiAccessKey;
    }

    public URI createURI(String query) {
        return this.createURI(query, new ArrayList());
    }

    public URI createURI(String query, NameValuePair ... param) {
        return this.createURI(query, Arrays.asList(param));
    }

    private URI createURI(String query, Collection<? extends NameValuePair> origParams) {
        URI uri;
        ArrayList<? extends NameValuePair> params = new ArrayList<NameValuePair>(origParams);
        if (this.apiAccessKey != null) {
            params.add((NameValuePair)new BasicNameValuePair("key", this.apiAccessKey));
        }
        try {
            URL url = this.baseURL;
            String path = url.getPath();
            if (!query.isEmpty()) {
                path = path + "/" + query;
            }
            uri = URIUtils.createURI((String)url.getProtocol(), (String)url.getHost(), (int)url.getPort(), (String)path, (String)URLEncodedUtils.format(params, (String)"UTF-8"), null);
        }
        catch (URISyntaxException e) {
            throw new RedmineInternalError(e);
        }
        return uri;
    }

    public URI getChildObjectsURI(Class<?> parent, String parentId, Class<?> child, NameValuePair ... args) {
        String base = this.getConfig(parent);
        String detal = this.getConfig(child);
        return this.createURI(base + "/" + parentId + "/" + detal + URL_POSTFIX, args);
    }

    public URI getObjectsURI(Class<?> child, NameValuePair ... args) {
        String detal = this.getConfig(child);
        return this.createURI(detal + URL_POSTFIX, args);
    }

    public URI getObjectsURI(Class<?> child, Collection<? extends NameValuePair> args) {
        String detal = this.getConfig(child);
        return this.createURI(detal + URL_POSTFIX, args);
    }

    public URI getObjectURI(Class<?> object, String id, NameValuePair ... args) {
        String detal = this.getConfig(object);
        return this.createURI(detal + "/" + id + URL_POSTFIX, args);
    }

    private String getConfig(Class<?> item) {
        String guess = urls.get(item);
        if (guess == null) {
            throw new RedmineInternalError("Unsupported item class " + item.getCanonicalName());
        }
        return guess;
    }

    public URI getUploadURI() {
        return this.createURI("uploads.json");
    }

    static {
        urls.put(User.class, "users");
        urls.put(Issue.class, "issues");
        urls.put(Project.class, "projects");
        urls.put(TimeEntry.class, "time_entries");
        urls.put(SavedQuery.class, "queries");
        urls.put(IssueStatus.class, "issue_statuses");
        urls.put(Version.class, "versions");
        urls.put(IssueCategory.class, "issue_categories");
        urls.put(Tracker.class, "trackers");
        urls.put(Attachment.class, "attachments");
        urls.put(News.class, "news");
        urls.put(IssueRelation.class, "relations");
        urls.put(Role.class, "roles");
        urls.put(Membership.class, "memberships");
    }
}

